"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NameConfigurationPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NameConfigurationPanel = ({
  isLoading,
  readOnly,
  nameFieldProps
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s",
  "data-test-subj": "sourceConfigurationNameSectionTitle"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.sourceConfiguration.nameSectionTitle",
  defaultMessage: "Name"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
  title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.nameLabel",
    defaultMessage: "Name"
  })),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.nameDescription",
    defaultMessage: "A descriptive name for the source configuration"
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  error: nameFieldProps.error,
  fullWidth: true,
  isInvalid: nameFieldProps.isInvalid,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.nameLabel",
    defaultMessage: "Name"
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
  "data-test-subj": "nameInput",
  fullWidth: true,
  disabled: isLoading,
  readOnly: readOnly,
  isLoading: isLoading
}, nameFieldProps)))));
exports.NameConfigurationPanel = NameConfigurationPanel;