"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseInferenceSpanProcessor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _sdk = require("@elastic/opentelemetry-node/sdk");
var _is_in_inference_context = require("./is_in_inference_context");
var _root_inference_span = require("./root_inference_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BaseInferenceSpanProcessor {
  constructor(exporter, scheduledDelayMillis) {
    (0, _defineProperty2.default)(this, "delegate", void 0);
    this.delegate = new _sdk.tracing.BatchSpanProcessor(exporter, {
      scheduledDelayMillis
    });
  }
  onStart(span, parentContext) {
    const shouldTrack = ((0, _is_in_inference_context.isInInferenceContext)(parentContext) || span.instrumentationScope.name === 'inference') && span.instrumentationScope.name !== '@elastic/transport';
    if (shouldTrack) {
      span.setAttribute('_should_track', true);
      this.delegate.onStart(span, parentContext);
    }
  }
  onEnd(span) {
    if (span.attributes._should_track) {
      delete span.attributes._should_track;

      // if this is the "root" inference span, but has a parent,
      // drop the parent context and Langfuse only shows root spans
      if (span.attributes[_root_inference_span.IS_ROOT_INFERENCE_SPAN_ATTRIBUTE_NAME] && span.parentSpanContext) {
        span = {
          ...span,
          spanContext: span.spanContext.bind(span),
          parentSpanContext: undefined
        };
      }
      delete span.attributes[_root_inference_span.IS_ROOT_INFERENCE_SPAN_ATTRIBUTE_NAME];
      span = this.processInferenceSpan(span);
      this.delegate.onEnd(span);
    }
  }
  forceFlush() {
    return this.delegate.forceFlush();
  }
  shutdown() {
    return this.delegate.shutdown();
  }
}
exports.BaseInferenceSpanProcessor = BaseInferenceSpanProcessor;