"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanGeometry = cleanGeometry;
exports.geoJsonCleanAndValidate = geoJsonCleanAndValidate;
var jsts = _interopRequireWildcard(require("jsts"));
var _geojsonRewind = _interopRequireDefault(require("@mapbox/geojson-rewind"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// The GeoJSON specification suggests limiting coordinate precision to six decimal places
// See https://datatracker.ietf.org/doc/html/rfc7946#section-11.2
// We can enforce rounding to six decimal places by setting the PrecisionModel scale
// scale = 10^n where n = maximum number of decimal places
const precisionModel = new jsts.geom.PrecisionModel(Math.pow(10, 6));
const geometryPrecisionReducer = new jsts.precision.GeometryPrecisionReducer(precisionModel);
geometryPrecisionReducer.setChangePrecisionModel(true);
const geoJSONReader = new jsts.io.GeoJSONReader();
const geoJSONWriter = new jsts.io.GeoJSONWriter();
function geoJsonCleanAndValidate(feature) {
  let cleanedGeometry;
  // Attempts to clean geometry. If this fails, don't generate errors at this
  // point, these will be handled more accurately on write to ES with feedback
  // given to user
  try {
    const geometryReadResult = geoJSONReader.read(feature);
    cleanedGeometry = cleanGeometry(geometryReadResult);
  } catch (e) {
    return feature;
  }

  // JSTS does not enforce winding order, wind in clockwise order
  const correctlyWindedGeometry = (0, _geojsonRewind.default)(cleanedGeometry, false);
  return {
    ...feature,
    geometry: correctlyWindedGeometry
  };
}
function cleanGeometry({
  geometry
}) {
  if (!geometry) {
    return null;
  }

  // GeometryPrecisionReducer will automatically clean invalid geometries
  const geometryToWrite = geometryPrecisionReducer.reduce(geometry);
  return geoJSONWriter.write(geometryToWrite);
}