"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceConfigFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../constants");
var _api_key = require("../api_key");
var _credential_item = require("../credential_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceConfigFields = ({
  isOauth1,
  sourceConfigData
}) => {
  const {
    configuredFields,
    configurableFields = [],
    serviceType
  } = sourceConfigData;

  // TODO use configurableFields instead of static field names
  const {
    public_key: publicKey,
    consumer_key: consumerKey,
    external_connector_api_key: externalConnectorApiKey,
    external_connector_url: externalConnectorUrl
  } = configuredFields;
  const credentialItem = (label, item) => item && /*#__PURE__*/_react.default.createElement("div", {
    key: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_credential_item.CredentialItem, {
    label: label,
    value: item,
    testSubj: label,
    hideCopy: true
  }));
  const keyElement = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, publicKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_api_key.ApiKey, {
    label: _constants.PUBLIC_KEY_LABEL,
    apiKey: publicKey
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), consumerKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_api_key.ApiKey, {
    label: _constants.CONSUMER_KEY_LABEL,
    apiKey: consumerKey
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)));
  const formFields = serviceType === 'external' ? configurableFields : [{
    key: 'client_id',
    label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sourceConfigFields.clientIDLabel', {
      defaultMessage: 'Client ID'
    })
  }, {
    key: 'client_secret',
    label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sourceConfigFields.clientSecretLabel', {
      defaultMessage: 'Client Secret'
    })
  }, {
    key: 'base_url',
    label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sourceConfigFields.baseUrlLabel', {
      defaultMessage: 'Base URL'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isOauth1 && keyElement, formFields.map(({
    key,
    label
  }) => credentialItem(label, configuredFields[key])), credentialItem(_constants.EXTERNAL_CONNECTOR_API_KEY_LABEL, externalConnectorApiKey), externalConnectorUrl && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _constants.EXTERNAL_CONNECTOR_URL_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: _constants.COPY_TOOLTIP,
    afterMessage: _constants.COPIED_TOOLTIP,
    textToCopy: externalConnectorUrl
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _constants.COPY_TOOLTIP,
    onClick: copy,
    iconType: "copy",
    color: "primary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: true,
    placeholder: "https://URL",
    "data-test-subj": "external-connector-url-input",
    value: externalConnectorUrl,
    compressed: true,
    onClick: e => e.currentTarget.select()
  })))))));
};
exports.SourceConfigFields = SourceConfigFields;