"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountFlashMessagesLogic = exports.FlashMessagesLogic = void 0;
var _kea = require("kea");
var _kibana = require("../kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToArray = messages => !Array.isArray(messages) ? [messages] : messages;
const FlashMessagesLogic = exports.FlashMessagesLogic = (0, _kea.kea)({
  actions: {
    clearFlashMessages: () => null,
    clearQueuedMessages: () => null,
    setFlashMessages: messages => ({
      messages: convertToArray(messages)
    }),
    setHistoryListener: historyListener => ({
      historyListener
    }),
    setQueuedMessages: messages => ({
      messages: convertToArray(messages)
    })
  },
  path: ['enterprise_search', 'flash_messages_logic'],
  reducers: ({
    props
  }) => ({
    historyListener: [null, {
      setHistoryListener: (_, {
        historyListener
      }) => historyListener
    }],
    messages: [[], {
      clearFlashMessages: () => [],
      setFlashMessages: (_, {
        messages
      }) => messages
    }],
    notifications: [props.notifications || {}, {}],
    queuedMessages: [[], {
      clearQueuedMessages: () => [],
      setQueuedMessages: (_, {
        messages
      }) => messages
    }]
  }),
  events: ({
    values,
    actions
  }) => ({
    afterMount: () => {
      // On React Router navigation, clear previous flash messages and load any queued messages
      const unlisten = _kibana.KibanaLogic.values.history.listen(() => {
        actions.clearFlashMessages();
        actions.setFlashMessages(values.queuedMessages);
        actions.clearQueuedMessages();
      });
      actions.setHistoryListener(unlisten);
    },
    beforeUnmount: () => {
      const {
        historyListener: removeHistoryListener
      } = values;
      if (removeHistoryListener) removeHistoryListener();
    }
  })
});

/**
 * Mount/props helper
 */
const mountFlashMessagesLogic = props => {
  FlashMessagesLogic(props);
  const unmount = FlashMessagesLogic.mount();
  return unmount;
};
exports.mountFlashMessagesLogic = mountFlashMessagesLogic;