"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDomainFormSubmitButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _add_domain_logic = require("./add_domain_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddDomainFormSubmitButton = () => {
  const {
    submitNewDomain
  } = (0, _kea.useActions)(_add_domain_logic.AddDomainLogic);
  const {
    allowSubmit
  } = (0, _kea.useValues)(_add_domain_logic.AddDomainLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "button",
    disabled: !allowSubmit,
    onClick: submitNewDomain,
    "data-test-subj": "entSearchContent-crawler-addDomain-submitButton"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.submitButtonLabel', {
    defaultMessage: 'Add domain'
  }));
};
exports.AddDomainFormSubmitButton = AddDomainFormSubmitButton;