"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueBoostForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _ = require("../..");
var _multi_input_rows = require("../../../multi_input_rows");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ValueBoostForm = ({
  boost,
  index,
  name
}) => {
  const {
    updateBoostValue
  } = (0, _kea.useActions)(_.RelevanceTuningLogic);
  const values = boost.value;
  return /*#__PURE__*/_react.default.createElement(_multi_input_rows.MultiInputRows, {
    initialValues: values,
    onChange: updatedValues => updateBoostValue(name, index, updatedValues),
    id: `${name}BoostValue-${index}`
  });
};
exports.ValueBoostForm = ValueBoostForm;