"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Summary = exports.FlyoutHeader = exports.FlyoutFooter = exports.FlyoutBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _constants = require("../../../../shared/constants");
var _constants2 = require("../constants");
var _types = require("../types");
var _summary_sections = require("./summary_sections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Summary = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlyoutHeader, null), /*#__PURE__*/_react.default.createElement(FlyoutBody, null), /*#__PURE__*/_react.default.createElement(FlyoutFooter, null));
};
exports.Summary = Summary;
const FlyoutHeader = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: _constants2.FLYOUT_ARIA_LABEL_ID
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.title', {
    defaultMessage: 'Indexing summary'
  }))));
};
exports.FlyoutHeader = FlyoutHeader;
const FlyoutBody = () => {
  const {
    summary
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  const hasInvalidDocuments = summary.invalidDocuments.total > 0;
  const invalidDocumentsBanner = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: _constants2.DOCUMENT_CREATION_ERRORS.TITLE
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: hasInvalidDocuments && invalidDocumentsBanner
  }, /*#__PURE__*/_react.default.createElement(_summary_sections.InvalidDocumentsSummary, null), /*#__PURE__*/_react.default.createElement(_summary_sections.ValidDocumentsSummary, null), /*#__PURE__*/_react.default.createElement(_summary_sections.SchemaFieldsSummary, null));
};
exports.FlyoutBody = FlyoutBody;
const FlyoutFooter = () => {
  const {
    setCreationStep,
    closeDocumentCreation
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  const {
    summary
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  const hasInvalidDocuments = summary.invalidDocuments.total > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: closeDocumentCreation
  }, _constants.CLOSE_BUTTON_LABEL)), hasInvalidDocuments && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: () => setCreationStep(_types.DocumentCreationStep.AddDocuments)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.fixErrors', {
    defaultMessage: 'Fix errors'
  })))));
};
exports.FlyoutFooter = FlyoutFooter;