"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryDetail = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _encode_path_params = require("../../../utils/encode_path_params");
var _analytics_layout = require("../analytics_layout");
var _components = require("../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_DETAIL_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.queryDetail.title', {
  defaultMessage: 'Query'
});
const QueryDetail = () => {
  const {
    query
  } = (0, _encode_path_params.useDecodedParams)();
  const queryTitle = query === '""' ? query : `"${query}"`;
  const {
    totalQueriesForQuery,
    queriesPerDayForQuery,
    startDate,
    topClicksForQuery
  } = (0, _kea.useValues)(_.AnalyticsLogic);
  return /*#__PURE__*/_react.default.createElement(_analytics_layout.AnalyticsLayout, {
    isQueryView: true,
    title: queryTitle,
    breadcrumbs: [QUERY_DETAIL_TITLE, query]
  }, /*#__PURE__*/_react.default.createElement(_.AnalyticsCards, {
    stats: [{
      stat: totalQueriesForQuery,
      text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.queryDetail.cardDescription', {
        defaultMessage: 'Queries for {queryTitle}',
        values: {
          queryTitle: query
        }
      })
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_.AnalyticsChart, {
    lines: [{
      id: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.queryDetail.chartTooltip', {
        defaultMessage: 'Queries per day'
      }),
      data: (0, _.convertToChartData)({
        startDate,
        data: queriesPerDayForQuery
      })
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.AnalyticsSection, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.queryDetail.tableTitle', {
      defaultMessage: 'Top clicks'
    }),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.queryDetail.tableDescription', {
      defaultMessage: 'The documents with the most clicks resulting from this query.'
    })
  }, /*#__PURE__*/_react.default.createElement(_components.QueryClicksTable, {
    items: topClicksForQuery
  })));
};
exports.QueryDetail = QueryDetail;