"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPatternDataSourceProfileProvider = void 0;
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _i18n = require("@kbn/i18n");
var _data_sources = require("../../../../../common/data_sources");
var _profiles = require("../../../profiles");
var _pattern_cell_renderer = require("./pattern_cell_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DOC_LIMIT = 10000;
const createPatternDataSourceProfileProvider = services => ({
  profileId: 'patterns-data-source-profile',
  profile: {
    getCellRenderers: (prev, {
      context
    }) => params => {
      const {
        rowHeight
      } = params;
      const {
        patternColumns
      } = context;
      if (!patternColumns || patternColumns.length === 0) {
        return prev(params);
      }
      const patternRenderers = patternColumns.reduce((acc, column) => Object.assign(acc, {
        [column]: props => (0, _pattern_cell_renderer.getPatternCellRenderer)(props.row, props.columnId, props.isDetails, rowHeight)
      }), {});
      return {
        ...prev(params),
        ...patternRenderers
      };
    },
    getAdditionalCellActions: (prev, {
      context
    }) => () => {
      return [...prev(), {
        id: 'patterns-action-view-docs-in-discover',
        getDisplayName: () => _i18n.i18n.translate('discover.docViews.patterns.cellAction.viewResults', {
          defaultMessage: 'View matching results'
        }),
        getIconType: () => 'discoverApp',
        isCompatible: compatibleContext => {
          const {
            query,
            field
          } = compatibleContext;
          const {
            patternColumns
          } = context;
          if (!(0, _esQuery.isOfAggregateQueryType)(query) || field === undefined) {
            return false;
          }
          return patternColumns.includes(field.name);
        },
        execute: executeContext => {
          var _executeContext$dataV;
          const index = (_executeContext$dataV = executeContext.dataView) === null || _executeContext$dataV === void 0 ? void 0 : _executeContext$dataV.getIndexPattern();
          if (!(0, _esQuery.isOfAggregateQueryType)(executeContext.query) || !executeContext.value || !index) {
            return;
          }
          const pattern = (0, _esqlUtils.extractCategorizeTokens)(executeContext.value).join(' ');
          const categoryField = (0, _esqlUtils.getCategorizeField)(executeContext.query.esql);
          if (!categoryField || !pattern) {
            return;
          }
          const query = {
            ...executeContext.query,
            esql: `FROM ${index}\n  | WHERE MATCH(${categoryField}, "${pattern}", {"auto_generate_synonyms_phrase_query": false, "fuzziness": 0, "operator": "AND"})\n  | LIMIT ${DOC_LIMIT}`
          };
          const discoverLink = services.locator.getRedirectUrl({
            query,
            timeRange: executeContext.timeRange,
            hideChart: false
          });
          window.open(discoverLink, '_blank');
        }
      }];
    },
    getDefaultAppState: prev => params => {
      return {
        ...prev(params),
        columns: [{
          name: 'Count',
          width: 150
        }, {
          name: 'Pattern',
          width: undefined
        }]
      };
    },
    getModifiedVisAttributes: prev => params => {
      const prevAttributes = prev(params);
      if (prevAttributes.visualizationType === 'lnsXY') {
        const visualization = prevAttributes.state.visualization;
        if (visualization.tickLabelsVisibilitySettings) {
          visualization.tickLabelsVisibilitySettings.x = false;
        }
      }
      return prevAttributes;
    }
  },
  resolve: params => {
    if (!(0, _data_sources.isDataSourceType)(params.dataSource, _data_sources.DataSourceType.Esql)) {
      return {
        isMatch: false
      };
    }
    const query = params.query;
    if (!(0, _esQuery.isOfAggregateQueryType)(query)) {
      return {
        isMatch: false
      };
    }
    const patternColumns = (0, _esqlUtils.getCategorizeColumns)(query.esql);
    if (patternColumns.length === 0) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        category: _profiles.DataSourceCategory.Default,
        patternColumns
      }
    };
  }
});
exports.createPatternDataSourceProfileProvider = createPatternDataSourceProfileProvider;