"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverLayout = DiscoverLayout;
require("./discover_layout.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _analytics = require("@kbn/analytics");
var _classnames = _interopRequireDefault(require("classnames"));
var _public = require("@kbn/data-plugin/public");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _public2 = require("@kbn/data-views-plugin/public");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _rxjs = require("rxjs");
var _discoverUtils = require("@kbn/discover-utils");
var _reactQuery = require("@kbn/react-query");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _constants = require("../../../../../common/constants");
var _discover_app_state_container = require("../../state_management/discover_app_state_container");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _no_results = require("../no_results");
var _loading_spinner = require("../loading_spinner/loading_spinner");
var _sidebar = require("../sidebar");
var _discover_topnav = require("../top_nav/discover_topnav");
var _get_result_state = require("../../utils/get_result_state");
var _uninitialized = require("../uninitialized/uninitialized");
var _types = require("../../../types");
var _use_data_state = require("../../hooks/use_data_state");
var _saved_search_url_conflict_callout = require("../../../../components/saved_search_url_conflict_callout/saved_search_url_conflict_callout");
var _discover_histogram_layout = require("./discover_histogram_layout");
var _error_callout = require("../../../../components/common/error_callout");
var _add_log = require("../../../../utils/add_log");
var _discover_resizable_layout = require("./discover_resizable_layout");
var _panels_toggle = require("../../../../components/panels_toggle");
var _use_saved_search_messages = require("../../hooks/use_saved_search_messages");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _redux = require("../../state_management/redux");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SidebarMemoized = /*#__PURE__*/_react.default.memo(_sidebar.DiscoverSidebarResponsive);
const TopNavMemoized = /*#__PURE__*/_react.default.memo(props =>
/*#__PURE__*/
// QueryClientProvider is used to allow querying the authorized rules api hook
_react.default.createElement(_reactQuery.QueryClientProvider, {
  client: new _reactQuery.QueryClient()
}, /*#__PURE__*/_react.default.createElement(_discover_topnav.DiscoverTopNav, props)));
function DiscoverLayout({
  stateContainer
}) {
  const {
    trackUiMetric,
    capabilities,
    dataViews,
    data,
    uiSettings,
    filterManager,
    history,
    spaces,
    observabilityAIAssistant,
    dataVisualizer: dataVisualizerService,
    ebtManager,
    fieldsMetadata
  } = (0, _use_discover_services.useDiscoverServices)();
  const pageBackgroundColor = (0, _eui.useEuiBackgroundColor)('plain');
  const globalQueryState = data.query.getState();
  const {
    main$
  } = stateContainer.dataState.data$;
  const [query, savedQuery, columns, sort, grid] = (0, _discover_app_state_container.useAppStateSelector)(state => [state.query, state.savedQuery, state.columns, state.sort, state.grid]);
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const viewMode = (0, _discover_app_state_container.useAppStateSelector)(state => {
    var _state$viewMode;
    const fieldStatsNotAvailable = !uiSettings.get(_discoverUtils.SHOW_FIELD_STATISTICS) && !!dataVisualizerService;
    if (state.viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL && fieldStatsNotAvailable) {
      return _constants.VIEW_MODE.DOCUMENT_LEVEL;
    }
    return (_state$viewMode = state.viewMode) !== null && _state$viewMode !== void 0 ? _state$viewMode : _constants.VIEW_MODE.DOCUMENT_LEVEL;
  });
  const dataView = (0, _redux.useCurrentDataView)();
  const dataViewLoading = (0, _redux.useInternalStateSelector)(state => state.isDataViewLoading);
  const customFilters = (0, _redux.useInternalStateSelector)(state => state.customFilters);
  const dataState = (0, _use_data_state.useDataState)(main$);
  const savedSearch = (0, _discover_state_provider.useSavedSearchInitial)();
  const fetchCounter = (0, _react.useRef)(0);
  (0, _react.useEffect)(() => {
    if (dataState.fetchStatus === _types.FetchStatus.LOADING) {
      fetchCounter.current++;
    }
  }, [dataState.fetchStatus]);

  // We treat rollup v1 data views as non time based in Discover, since we query them
  // in a non time based way using the regular _search API, since the internal
  // representation of those documents does not have the time field that _field_caps
  // reports us.
  const isTimeBased = (0, _react.useMemo)(() => {
    return dataView.type !== _public2.DataViewType.ROLLUP && dataView.isTimeBased();
  }, [dataView]);
  const useNewFieldsApi = (0, _react.useMemo)(() => !uiSettings.get(_discoverUtils.SEARCH_FIELDS_FROM_SOURCE), [uiSettings]);
  const resultState = (0, _react.useMemo)(() => {
    var _dataState$foundDocum;
    return (0, _get_result_state.getResultState)(dataState.fetchStatus, (_dataState$foundDocum = dataState.foundDocuments) !== null && _dataState$foundDocum !== void 0 ? _dataState$foundDocum : false);
  }, [dataState.fetchStatus, dataState.foundDocuments]);
  const setAppState = (0, _react.useCallback)(({
    settings,
    ...rest
  }) => {
    stateContainer.appState.update({
      ...rest,
      grid: settings
    });
  }, [stateContainer]);
  const {
    columns: currentColumns,
    onAddColumn,
    onRemoveColumn
  } = (0, _unifiedDataTable.useColumns)({
    capabilities,
    defaultOrder: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    dataView,
    dataViews,
    setAppState,
    useNewFieldsApi,
    columns,
    sort,
    settings: grid
  });
  const onAddColumnWithTracking = (0, _react.useCallback)(columnName => {
    onAddColumn(columnName);
    void ebtManager.trackDataTableSelection({
      fieldName: columnName,
      fieldsMetadata
    });
  }, [onAddColumn, ebtManager, fieldsMetadata]);
  const onRemoveColumnWithTracking = (0, _react.useCallback)(columnName => {
    onRemoveColumn(columnName);
    void ebtManager.trackDataTableRemoval({
      fieldName: columnName,
      fieldsMetadata
    });
  }, [onRemoveColumn, ebtManager, fieldsMetadata]);

  // The assistant is getting the state from the url correctly
  // expect from the index pattern where we have only the dataview id
  (0, _react.useEffect)(() => {
    return observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service.setScreenContext({
      screenDescription: `The user is looking at the Discover view on the ${isEsqlMode ? 'ES|QL' : 'dataView'} mode. The index pattern is the ${dataView.getIndexPattern()}`
    });
  }, [dataView, isEsqlMode, observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service]);
  const onAddFilter = (0, _react.useCallback)((field, values, operation) => {
    if (!field) {
      return;
    }
    const fieldName = typeof field === 'string' ? field : field.name;
    (0, _unifiedDataTable.popularizeField)(dataView, fieldName, dataViews, capabilities);
    const newFilters = (0, _public.generateFilters)(filterManager, field, values, operation, dataView);
    if (trackUiMetric) {
      trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'filter_added');
    }
    void ebtManager.trackFilterAddition({
      fieldName: fieldName === '_exists_' ? String(values) : fieldName,
      filterOperation: fieldName === '_exists_' ? '_exists_' : operation,
      fieldsMetadata
    });
    return filterManager.addFilters(newFilters);
  }, [filterManager, dataView, dataViews, trackUiMetric, capabilities, ebtManager, fieldsMetadata]);
  const onPopulateWhereClause = (0, _react.useCallback)((field, values, operation) => {
    if (!field || !(0, _esQuery.isOfAggregateQueryType)(query)) {
      return;
    }
    const fieldName = typeof field === 'string' ? field : field.name;
    // send the field type for casting
    const fieldType = typeof field !== 'string' ? field.type : undefined;
    // weird existence logic from Discover components
    // in the field it comes the operator _exists_ and in the value the field
    // I need to take care of it here but I think it should be handled on the fieldlist instead
    const updatedQuery = (0, _esqlUtils.appendWhereClauseToESQLQuery)(query.esql, fieldName === '_exists_' ? String(values) : fieldName, fieldName === '_exists_' || values == null ? undefined : values, getOperator(fieldName, values, operation), fieldType);
    if (!updatedQuery) {
      return;
    }
    data.query.queryString.setQuery({
      esql: updatedQuery
    });
    if (trackUiMetric) {
      trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'esql_filter_added');
    }
    void ebtManager.trackFilterAddition({
      fieldName: fieldName === '_exists_' ? String(values) : fieldName,
      filterOperation: fieldName === '_exists_' ? '_exists_' : operation,
      fieldsMetadata
    });
  }, [data.query.queryString, query, trackUiMetric, ebtManager, fieldsMetadata]);
  const onFilter = isEsqlMode ? onPopulateWhereClause : onAddFilter;
  const canSetBreakdownField = (0, _react.useMemo)(() => (0, _esQuery.isOfAggregateQueryType)(query) ? (dataView === null || dataView === void 0 ? void 0 : dataView.isTimeBased()) && !(0, _esqlUtils.hasTransformationalCommand)(query.esql) : true, [dataView, query]);
  const onAddBreakdownField = (0, _react.useCallback)(field => {
    stateContainer.appState.update({
      breakdownField: field === null || field === void 0 ? void 0 : field.name
    });
  }, [stateContainer]);
  const onFieldEdited = (0, _react.useCallback)(async ({
    removedFieldName
  } = {}) => {
    if (removedFieldName && currentColumns.includes(removedFieldName)) {
      onRemoveColumn(removedFieldName);
    }
    if (!dataView.isPersisted()) {
      await stateContainer.actions.updateAdHocDataViewId();
    }
    stateContainer.dataState.refetch$.next('reset');
  }, [dataView, stateContainer, currentColumns, onRemoveColumn]);
  const onDisableFilters = (0, _react.useCallback)(() => {
    const disabledFilters = filterManager.getFilters().map(filter => ({
      ...filter,
      meta: {
        ...filter.meta,
        disabled: true
      }
    }));
    filterManager.setFilters(disabledFilters);
  }, [filterManager]);
  const contentCentered = resultState === 'uninitialized' || resultState === 'none';
  const documentState = (0, _use_data_state.useDataState)(stateContainer.dataState.data$.documents$);
  const esqlModeWarning = (0, _react.useMemo)(() => {
    if (isEsqlMode) {
      return documentState.esqlHeaderWarning;
    }
  }, [documentState.esqlHeaderWarning, isEsqlMode]);
  const esqlModeErrors = (0, _react.useMemo)(() => {
    if (isEsqlMode) {
      return dataState.error;
    }
  }, [dataState.error, isEsqlMode]);
  const [sidebarContainer, setSidebarContainer] = (0, _react.useState)(null);
  const [mainContainer, setMainContainer] = (0, _react.useState)(null);
  const [{
    dragging
  }] = (0, _domDragDrop.useDragDropContext)();
  const draggingFieldName = dragging === null || dragging === void 0 ? void 0 : dragging.id;
  const onDropFieldToTable = (0, _react.useMemo)(() => {
    if (!draggingFieldName || currentColumns.includes(draggingFieldName)) {
      return undefined;
    }
    return () => onAddColumnWithTracking(draggingFieldName);
  }, [onAddColumnWithTracking, draggingFieldName, currentColumns]);
  const [sidebarToggleState$] = (0, _react.useState)(() => new _rxjs.BehaviorSubject({
    isCollapsed: false,
    toggle: () => {}
  }));
  const panelsToggle = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_panels_toggle.PanelsToggle, {
      stateContainer: stateContainer,
      sidebarToggleState$: sidebarToggleState$,
      renderedFor: "root",
      isChartAvailable: undefined
    });
  }, [stateContainer, sidebarToggleState$]);
  const mainDisplay = (0, _react.useMemo)(() => {
    if (resultState === 'uninitialized') {
      (0, _add_log.addLog)('[DiscoverLayout] uninitialized triggers data fetching');
      return /*#__PURE__*/_react.default.createElement(_uninitialized.DiscoverUninitialized, {
        onRefresh: () => stateContainer.dataState.fetch()
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_discover_histogram_layout.DiscoverHistogramLayout, {
      dataView: dataView,
      stateContainer: stateContainer,
      columns: currentColumns,
      viewMode: viewMode,
      onAddFilter: onFilter,
      onFieldEdited: onFieldEdited,
      container: mainContainer,
      onDropFieldToTable: onDropFieldToTable,
      panelsToggle: panelsToggle
    }), resultState === 'loading' && /*#__PURE__*/_react.default.createElement(_loading_spinner.LoadingSpinner, null));
  }, [resultState, dataView, stateContainer, currentColumns, viewMode, onFilter, onFieldEdited, mainContainer, onDropFieldToTable, panelsToggle]);
  const isLoading = documentState.fetchStatus === _types.FetchStatus.LOADING || documentState.fetchStatus === _types.FetchStatus.PARTIAL;
  const onCancelClick = (0, _react.useCallback)(() => {
    stateContainer.dataState.cancel();
    (0, _use_saved_search_messages.sendErrorMsg)(stateContainer.dataState.data$.documents$);
    (0, _use_saved_search_messages.sendErrorMsg)(stateContainer.dataState.data$.main$);
  }, [stateContainer.dataState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    className: (0, _classnames.default)('dscPage', {
      'dscPage--topNavInline': stateContainer.customizationContext.inlineTopNav.enabled
    }),
    "data-fetch-counter": fetchCounter.current,
    css: (0, _react2.css)`
        background-color: ${pageBackgroundColor};
      `
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "savedSearchTitle",
    className: "euiScreenReaderOnly",
    "data-test-subj": "discoverSavedSearchTitle"
  }, savedSearch.title ? _i18n.i18n.translate('discover.pageTitleWithSavedSearch', {
    defaultMessage: 'Discover - {savedSearchTitle}',
    values: {
      savedSearchTitle: savedSearch.title
    }
  }) : _i18n.i18n.translate('discover.pageTitleWithoutSavedSearch', {
    defaultMessage: 'Discover - Search not yet saved'
  })), /*#__PURE__*/_react.default.createElement(TopNavMemoized, {
    savedQuery: savedQuery,
    stateContainer: stateContainer,
    esqlModeErrors: esqlModeErrors,
    esqlModeWarning: esqlModeWarning,
    onFieldEdited: onFieldEdited,
    isLoading: isLoading,
    onCancelClick: onCancelClick
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    className: "dscPageBody",
    "aria-describedby": "savedSearchTitle"
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: setSidebarContainer,
    css: (0, _react2.css)`
            width: 100%;
            height: 100%;
          `
  }, dataViewLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, {
    delay: 300
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  })), /*#__PURE__*/_react.default.createElement(_saved_search_url_conflict_callout.SavedSearchURLConflictCallout, {
    savedSearch: savedSearch,
    spaces: spaces,
    history: history
  }), /*#__PURE__*/_react.default.createElement(_discover_resizable_layout.DiscoverResizableLayout, {
    container: sidebarContainer,
    sidebarToggleState$: sidebarToggleState$,
    sidebarPanel: /*#__PURE__*/_react.default.createElement(SidebarMemoized, {
      additionalFilters: customFilters,
      columns: currentColumns,
      documents$: stateContainer.dataState.data$.documents$,
      onAddBreakdownField: canSetBreakdownField ? onAddBreakdownField : undefined,
      onAddField: onAddColumnWithTracking,
      onAddFilter: onFilter,
      onChangeDataView: stateContainer.actions.onChangeDataView,
      onDataViewCreated: stateContainer.actions.onDataViewCreated,
      onFieldEdited: onFieldEdited,
      onRemoveField: onRemoveColumnWithTracking,
      selectedDataView: dataView,
      sidebarToggleState$: sidebarToggleState$,
      trackUiMetric: trackUiMetric
    }),
    mainPanel: /*#__PURE__*/_react.default.createElement("div", {
      className: "dscPageContent__wrapper"
    }, resultState === 'none' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.isValidElement(panelsToggle) ? /*#__PURE__*/_react.default.createElement("div", {
      className: "dscPageContent__panelsToggleWhenNoResults"
    }, /*#__PURE__*/_react.default.cloneElement(panelsToggle, {
      renderedFor: 'prompt',
      isChartAvailable: false
    })) : null, dataState.error ? /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
      title: _i18n.i18n.translate('discover.noResults.searchExamples.noResultsErrorTitle', {
        defaultMessage: 'Unable to retrieve search results'
      }),
      error: dataState.error,
      isEsqlMode: isEsqlMode
    }) : /*#__PURE__*/_react.default.createElement(_no_results.DiscoverNoResults, {
      stateContainer: stateContainer,
      isTimeBased: isTimeBased,
      query: globalQueryState.query,
      filters: globalQueryState.filters,
      dataView: dataView,
      onDisableFilters: onDisableFilters
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      role: "main",
      panelRef: setMainContainer,
      paddingSize: "none",
      borderRadius: "none",
      hasShadow: false,
      hasBorder: false,
      color: "transparent",
      className: (0, _classnames.default)('dscPageContent', {
        'dscPageContent--centered': contentCentered
      })
    }, mainDisplay))
  }))));
}
const getOperator = (fieldName, values, operation) => {
  if (fieldName === '_exists_') {
    return 'is_not_null';
  }
  if (values == null && operation === '-') {
    return 'is_not_null';
  }
  if (values == null && operation === '+') {
    return 'is_null';
  }
  return operation;
};