"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamsMeteringStats = getDataStreamsMeteringStats;
var _process_async_in_chunks = require("../../../utils/process_async_in_chunks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamsMeteringStats({
  esClient,
  dataStreams
}) {
  if (!dataStreams.length) {
    return {};
  }
  const {
    datastreams: dataStreamsStats
  } = await (0, _process_async_in_chunks.processAsyncInChunks)(dataStreams, dataStreamsChunk => esClient.transport.request({
    method: 'GET',
    path: `/_metering/stats/` + dataStreamsChunk.join(',')
  }));
  return dataStreamsStats.reduce((acc, dataStream) => ({
    ...acc,
    [dataStream.name]: {
      sizeBytes: dataStream.size_in_bytes,
      totalDocs: dataStream.num_docs
    }
  }), {});
}