"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumnChartStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useColumnChartStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    fontSize: euiFontSizeL
  } = (0, _eui.useEuiFontSize)('l');
  return {
    histogram: (0, _react.css)({
      width: '100%'
    }),
    legend: (0, _react.css)`
      ${(0, _eui.euiTextTruncate)()};
      color: ${euiTheme.colors.textSubdued};
      display: block;
      overflow-x: hidden;
      font-style: italic;
      font-weight: ${euiTheme.font.weight.regular};
      text-align: left;
      line-height: 1.1;
      font-size: calc(${euiFontSizeL} / 2);
    `,
    legendNumeric: (0, _react.css)({
      textAlign: 'right'
    }),
    legendBoolean: (0, _react.css)`
      width: calc(${euiTheme.size.xs} * 2.5);
    `,
    dataGridHeader: (0, _react.css)({
      '.euiDataGridHeaderCell__content': {
        marginTop: 'auto'
      }
    })
  };
};
exports.useColumnChartStyles = useColumnChartStyles;