"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardApi = getDashboardApi;
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _constants = require("../../common/constants");
var _common = require("../../common");
var _dashboard_content_management_service = require("../services/dashboard_content_management_service");
var _control_group_manager = require("./control_group_manager");
var _data_loading_manager = require("./data_loading_manager");
var _data_views_manager = require("./data_views_manager");
var _default_dashboard_state = require("./default_dashboard_state");
var _get_serialized_state = require("./get_serialized_state");
var _layout_manager = require("./layout_manager");
var _open_save_modal = require("./save_modal/open_save_modal");
var _search_session_manager = require("./search_sessions/search_session_manager");
var _settings_manager = require("./settings_manager");
var _track_contentful_render = require("./track_contentful_render");
var _track_overlay = require("./track_overlay");
var _track_panel = require("./track_panel");
var _types = require("./types");
var _unified_search_manager = require("./unified_search_manager");
var _unsaved_changes_manager = require("./unsaved_changes_manager");
var _view_mode_manager = require("./view_mode_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDashboardApi({
  creationOptions,
  incomingEmbeddable,
  initialState,
  savedObjectResult,
  savedObjectId
}) {
  var _creationOptions$full, _savedObjectResult$ma, _savedObjectResult$da;
  const fullScreenMode$ = new _rxjs.BehaviorSubject((_creationOptions$full = creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.fullScreenMode) !== null && _creationOptions$full !== void 0 ? _creationOptions$full : false);
  const isManaged = (_savedObjectResult$ma = savedObjectResult === null || savedObjectResult === void 0 ? void 0 : savedObjectResult.managed) !== null && _savedObjectResult$ma !== void 0 ? _savedObjectResult$ma : false;
  const savedObjectId$ = new _rxjs.BehaviorSubject(savedObjectId);
  const viewModeManager = (0, _view_mode_manager.initializeViewModeManager)(incomingEmbeddable, savedObjectResult);
  const trackPanel = (0, _track_panel.initializeTrackPanel)(async id => {
    await layoutManager.api.getChildApi(id);
  });
  const references$ = new _rxjs.BehaviorSubject(initialState.references);
  const getReferences = id => {
    var _references$$value2;
    if (id === _control_group_manager.CONTROL_GROUP_EMBEDDABLE_ID) {
      var _references$$value;
      return (0, _common.getReferencesForControls)((_references$$value = references$.value) !== null && _references$$value !== void 0 ? _references$$value : []);
    }
    return (0, _common.getReferencesForPanelId)(id, (_references$$value2 = references$.value) !== null && _references$$value2 !== void 0 ? _references$$value2 : []);
  };
  const layoutManager = (0, _layout_manager.initializeLayoutManager)(incomingEmbeddable, initialState.panels, trackPanel, getReferences);
  const controlGroupManager = (0, _control_group_manager.initializeControlGroupManager)(initialState.controlGroupInput, getReferences);
  const dataLoadingManager = (0, _data_loading_manager.initializeDataLoadingManager)(layoutManager.api.children$);
  const dataViewsManager = (0, _data_views_manager.initializeDataViewsManager)(controlGroupManager.api.controlGroupApi$, layoutManager.api.children$);
  const settingsManager = (0, _settings_manager.initializeSettingsManager)(initialState);
  const unifiedSearchManager = (0, _unified_search_manager.initializeUnifiedSearchManager)(initialState, controlGroupManager.api.controlGroupApi$, settingsManager.api.timeRestore$, dataLoadingManager.internalApi.waitForPanelsToLoad$, () => unsavedChangesManager.internalApi.getLastSavedState(), creationOptions);
  const unsavedChangesManager = (0, _unsaved_changes_manager.initializeUnsavedChangesManager)({
    viewMode$: viewModeManager.api.viewMode$,
    storeUnsavedChanges: creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.useSessionStorageIntegration,
    controlGroupManager,
    lastSavedState: (_savedObjectResult$da = savedObjectResult === null || savedObjectResult === void 0 ? void 0 : savedObjectResult.dashboardInput) !== null && _savedObjectResult$da !== void 0 ? _savedObjectResult$da : _default_dashboard_state.DEFAULT_DASHBOARD_STATE,
    layoutManager,
    savedObjectId$,
    settingsManager,
    unifiedSearchManager,
    getReferences
  });
  function getState() {
    const {
      panels,
      references: panelReferences
    } = layoutManager.internalApi.serializeLayout();
    const {
      state: unifiedSearchState,
      references: searchSourceReferences
    } = unifiedSearchManager.internalApi.getState();
    const dashboardState = {
      ...settingsManager.api.getSettings(),
      ...unifiedSearchState,
      panels,
      viewMode: viewModeManager.api.viewMode$.value
    };
    const {
      controlGroupInput,
      controlGroupReferences
    } = controlGroupManager.internalApi.serializeControlGroup();
    dashboardState.controlGroupInput = controlGroupInput;
    return {
      dashboardState,
      controlGroupReferences,
      panelReferences: panelReferences !== null && panelReferences !== void 0 ? panelReferences : [],
      searchSourceReferences
    };
  }
  const trackOverlayApi = (0, _track_overlay.initializeTrackOverlay)(trackPanel.setFocusedPanelId);
  const dashboardApi = {
    ...viewModeManager.api,
    ...dataLoadingManager.api,
    ...dataViewsManager.api,
    ...layoutManager.api,
    ...settingsManager.api,
    ...trackPanel,
    ...unifiedSearchManager.api,
    ...unsavedChangesManager.api,
    ...trackOverlayApi,
    ...(0, _track_contentful_render.initializeTrackContentfulRender)(),
    ...controlGroupManager.api,
    executionContext: {
      type: 'dashboard',
      description: settingsManager.api.title$.value
    },
    fullScreenMode$,
    getAppContext: () => {
      var _creationOptions$getE, _embeddableAppContext;
      const embeddableAppContext = creationOptions === null || creationOptions === void 0 ? void 0 : (_creationOptions$getE = creationOptions.getEmbeddableAppContext) === null || _creationOptions$getE === void 0 ? void 0 : _creationOptions$getE.call(creationOptions, savedObjectId$.value);
      return {
        ...embeddableAppContext,
        currentAppId: (_embeddableAppContext = embeddableAppContext === null || embeddableAppContext === void 0 ? void 0 : embeddableAppContext.currentAppId) !== null && _embeddableAppContext !== void 0 ? _embeddableAppContext : _constants.DASHBOARD_APP_ID
      };
    },
    isEmbeddedExternally: Boolean(creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.isEmbeddedExternally),
    isManaged,
    reload$: (0, _rxjs.merge)(unifiedSearchManager.internalApi.controlGroupReload$, unifiedSearchManager.internalApi.panelsReload$).pipe((0, _rxjs.debounceTime)(0)),
    getSerializedState: () => (0, _get_serialized_state.getSerializedState)(getState()),
    runInteractiveSave: async () => {
      trackOverlayApi.clearOverlays();
      const saveResult = await (0, _open_save_modal.openSaveModal)({
        isManaged,
        lastSavedId: savedObjectId$.value,
        viewMode: viewModeManager.api.viewMode$.value,
        ...getState()
      });
      if (!saveResult || saveResult.error) {
        return;
      }
      if (saveResult) {
        var _saveResult$reference, _settings$hidePanelTi;
        unsavedChangesManager.internalApi.onSave(saveResult.savedState, (_saveResult$reference = saveResult.references) !== null && _saveResult$reference !== void 0 ? _saveResult$reference : []);
        const settings = settingsManager.api.getSettings();
        settingsManager.api.setSettings({
          ...settings,
          hidePanelTitles: (_settings$hidePanelTi = settings.hidePanelTitles) !== null && _settings$hidePanelTi !== void 0 ? _settings$hidePanelTi : false,
          description: saveResult.savedState.description,
          tags: saveResult.savedState.tags,
          timeRestore: saveResult.savedState.timeRestore,
          title: saveResult.savedState.title
        });
        savedObjectId$.next(saveResult.id);
        references$.next(saveResult.references);
      }
      return saveResult;
    },
    runQuickSave: async () => {
      if (isManaged) return;
      const {
        controlGroupReferences,
        dashboardState,
        panelReferences,
        searchSourceReferences
      } = getState();
      const saveResult = await (0, _dashboard_content_management_service.getDashboardContentManagementService)().saveDashboardState({
        controlGroupReferences,
        dashboardState,
        panelReferences,
        searchSourceReferences,
        saveOptions: {},
        lastSavedId: savedObjectId$.value
      });
      if (saveResult !== null && saveResult !== void 0 && saveResult.error) return;
      unsavedChangesManager.internalApi.onSave(dashboardState, searchSourceReferences);
      references$.next(saveResult.references);
      return;
    },
    savedObjectId$,
    setFullScreenMode: fullScreenMode => fullScreenMode$.next(fullScreenMode),
    getSerializedStateForChild: childId => {
      return childId === _control_group_manager.CONTROL_GROUP_EMBEDDABLE_ID ? controlGroupManager.internalApi.getStateForControlGroup() : layoutManager.internalApi.getSerializedStateForPanel(childId);
    },
    setSavedObjectId: id => savedObjectId$.next(id),
    type: _types.DASHBOARD_API_TYPE,
    uuid: (0, _uuid.v4)()
  };
  const internalApi = {
    ...layoutManager.internalApi,
    ...unifiedSearchManager.internalApi,
    setControlGroupApi: controlGroupManager.internalApi.setControlGroupApi,
    untilControlsInitialized: controlGroupManager.internalApi.untilControlsInitialized
  };
  const searchSessionManager = (0, _search_session_manager.initializeSearchSessionManager)(creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.searchSessionSettings, incomingEmbeddable, dashboardApi, internalApi);
  return {
    api: {
      ...dashboardApi,
      ...searchSessionManager.api
    },
    internalApi,
    cleanup: () => {
      dataLoadingManager.cleanup();
      dataViewsManager.cleanup();
      searchSessionManager.cleanup();
      unifiedSearchManager.cleanup();
      unsavedChangesManager.cleanup();
    }
  };
}