"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tiersConfigSchema = exports.pricingProductsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Schema defining the valid pricing product configurations.
 * Each product has a name and an associated tier that determines feature availability.
 *
 * @internal
 */
const pricingProductsSchema = exports.pricingProductsSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  name: _configSchema.schema.literal('observability'),
  tier: _configSchema.schema.oneOf([_configSchema.schema.literal('complete'), _configSchema.schema.literal('logs_essentials')])
}), _configSchema.schema.object({
  name: _configSchema.schema.literal('ai_soc'),
  tier: _configSchema.schema.literal('search_ai_lake')
}), _configSchema.schema.object({
  name: _configSchema.schema.literal('security'),
  tier: _configSchema.schema.oneOf([_configSchema.schema.literal('complete'), _configSchema.schema.literal('essentials'), _configSchema.schema.literal('search_ai_lake')])
}), _configSchema.schema.object({
  name: _configSchema.schema.literal('endpoint'),
  tier: _configSchema.schema.oneOf([_configSchema.schema.literal('complete'), _configSchema.schema.literal('essentials'), _configSchema.schema.literal('search_ai_lake')])
}), _configSchema.schema.object({
  name: _configSchema.schema.literal('cloud'),
  tier: _configSchema.schema.oneOf([_configSchema.schema.literal('complete'), _configSchema.schema.literal('essentials'), _configSchema.schema.literal('search_ai_lake')])
})]);

/**
 * Represents a product with an associated pricing tier.
 * Used to determine feature availability based on the current pricing configuration.
 *
 * @public
 */

/**
 * Schema defining the pricing tiers configuration structure.
 * Includes whether tiers are enabled and which products are active.
 *
 * @internal
 */
const tiersConfigSchema = exports.tiersConfigSchema = _configSchema.schema.object({
  enabled: (0, _configSchema.offeringBasedSchema)({
    serverless: _configSchema.schema.boolean({
      defaultValue: false
    }),
    traditional: _configSchema.schema.literal(false),
    options: {
      defaultValue: false
    }
  }),
  products: _configSchema.schema.maybe(_configSchema.schema.arrayOf(pricingProductsSchema))
});

/**
 * Configuration for pricing tiers that determines feature availability.
 * When enabled, features are only available if they're associated with an active product.
 * When disabled, all features are considered available.
 *
 * @public
 */