"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCaseConnectors = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _connectors_registry = require("./connectors_registry");
var _jira = require("./jira");
var _swimlane = require("./swimlane");
var _resilient = require("./resilient");
var _cases_webhook = require("./cases_webhook");
var _servicenow = require("./servicenow");
var _thehive = require("./thehive");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CaseConnectors {
  constructor() {
    (0, _defineProperty2.default)(this, "caseConnectorsRegistry", void 0);
    this.caseConnectorsRegistry = (0, _connectors_registry.createCaseConnectorsRegistry)();
    this.init();
  }
  init() {
    this.caseConnectorsRegistry.register((0, _jira.getCaseConnector)());
    this.caseConnectorsRegistry.register((0, _resilient.getCaseConnector)());
    this.caseConnectorsRegistry.register((0, _servicenow.getServiceNowITSMCaseConnector)());
    this.caseConnectorsRegistry.register((0, _servicenow.getServiceNowSIRCaseConnector)());
    this.caseConnectorsRegistry.register((0, _swimlane.getCaseConnector)());
    this.caseConnectorsRegistry.register((0, _cases_webhook.getCaseConnector)());
    this.caseConnectorsRegistry.register((0, _thehive.getCaseConnector)());
  }
  registry() {
    return this.caseConnectorsRegistry;
  }
}
const caseConnectors = new CaseConnectors();
const getCaseConnectors = () => ({
  caseConnectorsRegistry: caseConnectors.registry()
});
exports.getCaseConnectors = getCaseConnectors;