"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceStats = getServiceStats;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/apm-data-access-plugin/common");
var _common2 = require("@kbn/observability-plugin/common");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
var _environment_filter_values = require("../../../common/environment_filter_values");
var _transactions = require("../../lib/helpers/transactions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceStats({
  environment,
  apmEventClient,
  searchAggregatedTransactions,
  start,
  end,
  maxNumberOfServices,
  serviceGroupKuery,
  serviceName,
  kuery
}) {
  var _response$aggregation;
  const processorEvent = (0, _transactions.getProcessorEventForTransactions)(searchAggregatedTransactions);
  const shouldQueryMetrics = processorEvent === _common2.ProcessorEvent.metric;
  const params = {
    apm: shouldQueryMetrics ? {
      sources: [{
        documentType: _common.ApmDocumentType.ServiceTransactionMetric,
        rollupInterval: _common.RollupInterval.OneMinute
      }]
    } : {
      events: [processorEvent]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.termsQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.kqlQuery)(serviceGroupKuery), ...(0, _server.kqlQuery)(kuery)]
        }
      },
      aggs: {
        services: {
          terms: {
            field: _apm.SERVICE_NAME,
            size: maxNumberOfServices
          },
          aggs: {
            agent_name: {
              terms: {
                field: _apm.AGENT_NAME
              }
            }
          }
        }
      }
    }
  };
  const response = await apmEventClient.search('get_service_stats_for_service_map', params);
  const services = ((_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.services.buckets.map(bucket => {
    var _bucket$agent_name$bu;
    return {
      [_apm.SERVICE_NAME]: bucket.key,
      [_apm.AGENT_NAME]: ((_bucket$agent_name$bu = bucket.agent_name.buckets[0]) === null || _bucket$agent_name$bu === void 0 ? void 0 : _bucket$agent_name$bu.key) || '',
      [_apm.SERVICE_ENVIRONMENT]: environment === _environment_filter_values.ENVIRONMENT_ALL.value ? null : environment
    };
  })) || [];
  return services;
}