"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceMapFromTraceIds = getServiceMapFromTraceIds;
var _service_map = require("../../../common/service_map");
var _fetch_service_paths_from_trace_ids = require("./fetch_service_paths_from_trace_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceMapFromTraceIds({
  apmEventClient,
  traceIds,
  start,
  end,
  terminateAfter,
  serviceMapMaxAllowableBytes,
  numOfRequests,
  logger
}) {
  var _serviceMapFromTraceI, _serviceMapScriptedAg;
  const serviceMapFromTraceIdsScriptResponse = await (0, _fetch_service_paths_from_trace_ids.fetchServicePathsFromTraceIds)({
    apmEventClient,
    traceIds,
    start,
    end,
    terminateAfter,
    serviceMapMaxAllowableBytes,
    numOfRequests
  });
  logger.debug('Received scripted metric agg response');
  const serviceMapScriptedAggValue = (_serviceMapFromTraceI = serviceMapFromTraceIdsScriptResponse.aggregations) === null || _serviceMapFromTraceI === void 0 ? void 0 : _serviceMapFromTraceI.service_map.value;
  return {
    connections: (0, _service_map.getConnections)(serviceMapScriptedAggValue === null || serviceMapScriptedAggValue === void 0 ? void 0 : serviceMapScriptedAggValue.paths),
    discoveredServices: ((_serviceMapScriptedAg = serviceMapScriptedAggValue === null || serviceMapScriptedAggValue === void 0 ? void 0 : serviceMapScriptedAggValue.discoveredServices) !== null && _serviceMapScriptedAg !== void 0 ? _serviceMapScriptedAg : []).map(service => ({
      from: {
        ...service.from,
        id: (0, _service_map.getLegacyNodeId)(service.from)
      },
      to: {
        ...service.to,
        id: (0, _service_map.getLegacyNodeId)(service.to)
      }
    }))
  };
}