"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataTable = MetadataTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_url_params = require("../../../context/url_params_context/use_url_params");
var _height_retainer = require("../height_retainer");
var _url_helpers = require("../links/url_helpers");
var _helper = require("./helper");
var _section = require("./section");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MetadataTable({
  sections,
  isLoading
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    searchTerm = ''
  } = urlParams;
  const {
    docLinks
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  const filteredSections = (0, _helper.filterSectionsByTerm)(sections, searchTerm);
  const onSearchChange = (0, _react.useCallback)(e => {
    const value = e.target.value.trim().toLowerCase();
    history.replace({
      ...location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(location.search),
        searchTerm: value
      })
    });
  }, [history, location]);
  const noResultFound = Boolean(searchTerm) && (0, _lodash.isEmpty)(filteredSections);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "apmMetadataTableFieldSearch",
    onChange: onSearchChange,
    placeholder: _i18n.i18n.translate('xpack.apm.searchInput.filter', {
      defaultMessage: 'Filter...'
    }),
    isInvalid: noResultFound,
    value: searchTerm,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmMetadataTableHowToAddLabelsAndOtherDataLink",
    href: docLinks.links.apm.metaData,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "question"
  }), _i18n.i18n.translate('xpack.apm.metadata.help', {
    defaultMessage: 'How to add labels and other data'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null))), /*#__PURE__*/_react.default.createElement(_height_retainer.HeightRetainer, null, filteredSections.map(section => /*#__PURE__*/_react.default.createElement("div", {
    key: section.key
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, section.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_section.Section, {
    properties: section.properties
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }))), noResultFound && /*#__PURE__*/_react.default.createElement(NoResultFound, {
    value: searchTerm
  })));
}
function NoResultFound({
  value
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.apm.propertiesTable.agentFeature.noResultFound', {
    defaultMessage: `No results for "{value}".`,
    values: {
      value
    }
  }))));
}