"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColumnHeaderWithTooltip = ColumnHeaderWithTooltip;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ColumnHeaderWithTooltip({
  label,
  tooltipContent
}) {
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const onButtonClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    e.stopPropagation();
    togglePopover();
  }, [togglePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement("div", null, label), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "s",
    button: /*#__PURE__*/_react.default.createElement("button", {
      onClick: onButtonClick,
      "data-test-subj": "apmViewTableColumnPopoverButton"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question"
    })),
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    offset: 10,
    anchorPosition: "upCenter",
    panelStyle: {
      maxWidth: 350
    }
  }, tooltipContent));
}