"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessSummary = ServerlessSummary;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _formatters = require("../../../../../common/utils/formatters");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CentralizedContainer = _styledComponents.default.div`
  display: flex;
  align-items: center;
`;
const Border = _styledComponents.default.div`
  height: 55px;
  border-right: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
function VerticalRule() {
  return /*#__PURE__*/_react.default.createElement(CentralizedContainer, null, /*#__PURE__*/_react.default.createElement(Border, null));
}
function ServerlessSummary({
  serverlessId
}) {
  const breakpoints = (0, _use_breakpoints.useBreakpoints)();
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return undefined;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/metrics/serverless/summary', {
      params: {
        path: {
          serviceName
        },
        query: {
          kuery,
          environment,
          start,
          end,
          serverlessId
        }
      }
    });
  }, [kuery, environment, serviceName, start, end, serverlessId]);
  const showVerticalRule = !breakpoints.isSmall;
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.title', {
    defaultMessage: 'Summary'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmServerlessSummaryGiveFeedbackLink",
    href: "https://ela.st/feedback-aws-lambda",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.feedback', {
    defaultMessage: 'Give feedback'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    isLoading: isLoading,
    title: data === null || data === void 0 ? void 0 : data.serverlessFunctionsTotal,
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.lambdaFunctions', {
      defaultMessage: 'Lambda {serverlessFunctionsTotal, plural, one {function} other {functions}}',
      values: {
        serverlessFunctionsTotal: data === null || data === void 0 ? void 0 : data.serverlessFunctionsTotal
      }
    }),
    reverse: true
  })), showVerticalRule && /*#__PURE__*/_react.default.createElement(VerticalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    isLoading: isLoading,
    title: (0, _formatters.asMillisecondDuration)(data === null || data === void 0 ? void 0 : data.serverlessDurationAvg),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.functionDurationAvg', {
      defaultMessage: 'Function duration avg.'
    }),
    reverse: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    isLoading: isLoading,
    title: (0, _formatters.asMillisecondDuration)(data === null || data === void 0 ? void 0 : data.billedDurationAvg),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.billedDurationAvg', {
      defaultMessage: 'Billed duration avg.'
    }),
    reverse: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    isLoading: isLoading,
    title: (0, _formatters.asPercent)(data === null || data === void 0 ? void 0 : data.memoryUsageAvgRate, 1),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.memoryUsageAvg', {
      defaultMessage: 'Memory usage avg.'
    }),
    reverse: true
  })), showVerticalRule && /*#__PURE__*/_react.default.createElement(VerticalRule, null), (data === null || data === void 0 ? void 0 : data.estimatedCost) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    isLoading: isLoading,
    title: `$${data.estimatedCost}`,
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.estimatedCost', {
      defaultMessage: 'Estimated costs avg.'
    }),
    reverse: true
  }))));
}