"use strict";
/*
 * Copyright Elasticsearch B.V. and contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.EVENT_GEN_AI_CHOICE = exports.EVENT_GEN_AI_TOOL_MESSAGE = exports.EVENT_GEN_AI_ASSISTANT_MESSAGE = exports.EVENT_GEN_AI_USER_MESSAGE = exports.EVENT_GEN_AI_SYSTEM_MESSAGE = exports.ATTR_GEN_AI_REQUEST_ENCODING_FORMATS = exports.METRIC_GEN_AI_CLIENT_TOKEN_USAGE = exports.METRIC_GEN_AI_CLIENT_OPERATION_DURATION = exports.ATTR_GEN_AI_USAGE_OUTPUT_TOKENS = exports.ATTR_GEN_AI_USAGE_INPUT_TOKENS = exports.ATTR_GEN_AI_TOKEN_TYPE = exports.ATTR_GEN_AI_SYSTEM = exports.ATTR_GEN_AI_RESPONSE_MODEL = exports.ATTR_GEN_AI_RESPONSE_ID = exports.ATTR_GEN_AI_RESPONSE_FINISH_REASONS = exports.ATTR_GEN_AI_REQUEST_TOP_P = exports.ATTR_GEN_AI_REQUEST_PRESENCE_PENALTY = exports.ATTR_GEN_AI_REQUEST_MODEL = exports.ATTR_GEN_AI_REQUEST_MAX_TOKENS = exports.ATTR_GEN_AI_REQUEST_FREQUENCY_PENALTY = exports.ATTR_GEN_AI_OPERATION_NAME = exports.ATTR_EVENT_NAME = exports.ATTR_SERVER_PORT = exports.ATTR_SERVER_ADDRESS = void 0;
/**
 * Semantic-conventions constants.
 *
 * This instrumentation uses unstable semconv:
 *    https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv
 * OTel JS advice is to *copy* relevant definitions, rather than take a
 * dependency on `@opentelemetry/semantic-conventions` and use its
 * `.../incubating` entry-point.
 *
 * There are a small number of stable semconv defintions used, so the main
 * entry-point *could* be used. However, for now we opt to copy those
 * definitions as well.
 */
// -- Stable semconv
exports.ATTR_SERVER_ADDRESS = 'server.address';
exports.ATTR_SERVER_PORT = 'server.port';
// -- Unstable semconv
exports.ATTR_EVENT_NAME = 'event.name';
exports.ATTR_GEN_AI_OPERATION_NAME = 'gen_ai.operation.name';
exports.ATTR_GEN_AI_REQUEST_FREQUENCY_PENALTY = 'gen_ai.request.frequency_penalty';
exports.ATTR_GEN_AI_REQUEST_MAX_TOKENS = 'gen_ai.request.max_tokens';
exports.ATTR_GEN_AI_REQUEST_MODEL = 'gen_ai.request.model';
exports.ATTR_GEN_AI_REQUEST_PRESENCE_PENALTY = 'gen_ai.request.presence_penalty';
exports.ATTR_GEN_AI_REQUEST_TOP_P = 'gen_ai.request.top_p';
exports.ATTR_GEN_AI_RESPONSE_FINISH_REASONS = 'gen_ai.response.finish_reasons';
exports.ATTR_GEN_AI_RESPONSE_ID = 'gen_ai.response.id';
exports.ATTR_GEN_AI_RESPONSE_MODEL = 'gen_ai.response.model';
exports.ATTR_GEN_AI_SYSTEM = 'gen_ai.system';
exports.ATTR_GEN_AI_TOKEN_TYPE = 'gen_ai.token.type';
exports.ATTR_GEN_AI_USAGE_INPUT_TOKENS = 'gen_ai.usage.input_tokens';
exports.ATTR_GEN_AI_USAGE_OUTPUT_TOKENS = 'gen_ai.usage.output_tokens';
exports.METRIC_GEN_AI_CLIENT_OPERATION_DURATION = 'gen_ai.client.operation.duration';
exports.METRIC_GEN_AI_CLIENT_TOKEN_USAGE = 'gen_ai.client.token.usage';
exports.ATTR_GEN_AI_REQUEST_ENCODING_FORMATS = 'gen_ai.request.encoding_formats';
// The JS semconv package doesn't yet emit constants for event names.
// TODO: otel-js issue for semconv pkg not including event names
exports.EVENT_GEN_AI_SYSTEM_MESSAGE = 'gen_ai.system.message';
exports.EVENT_GEN_AI_USER_MESSAGE = 'gen_ai.user.message';
exports.EVENT_GEN_AI_ASSISTANT_MESSAGE = 'gen_ai.assistant.message';
exports.EVENT_GEN_AI_TOOL_MESSAGE = 'gen_ai.tool.message';
exports.EVENT_GEN_AI_CHOICE = 'gen_ai.choice';
//# sourceMappingURL=semconv.js.map