"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SPACINGS = exports.EuiDroppableContext = exports.EuiDroppable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dnd = require("@hello-pangea/dnd");
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _panel = require("../panel");
var _drag_drop_context = require("./drag_drop_context");
var _droppable = require("./droppable.styles");
var _react2 = require("@emotion/react");
var _excluded = ["droppableId", "direction", "isDropDisabled", "children", "className", "cloneDraggables", "spacing", "style", "type", "withPanel", "grow", "data-test-subj"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var SPACINGS = exports.SPACINGS = ['none', 's', 'm', 'l'];
var EuiDroppableContext = exports.EuiDroppableContext = /*#__PURE__*/_react.default.createContext({
  cloneItems: false
});
var EuiDroppable = exports.EuiDroppable = function EuiDroppable(_ref) {
  var droppableId = _ref.droppableId,
    direction = _ref.direction,
    _ref$isDropDisabled = _ref.isDropDisabled,
    isDropDisabled = _ref$isDropDisabled === void 0 ? false : _ref$isDropDisabled,
    children = _ref.children,
    className = _ref.className,
    _ref$cloneDraggables = _ref.cloneDraggables,
    cloneDraggables = _ref$cloneDraggables === void 0 ? false : _ref$cloneDraggables,
    _ref$spacing = _ref.spacing,
    spacing = _ref$spacing === void 0 ? 'none' : _ref$spacing,
    style = _ref.style,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'EUI_DEFAULT' : _ref$type,
    _ref$withPanel = _ref.withPanel,
    withPanel = _ref$withPanel === void 0 ? false : _ref$withPanel,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? false : _ref$grow,
    _ref$dataTestSubj = _ref['data-test-subj'],
    dataTestSubj = _ref$dataTestSubj === void 0 ? 'droppable' : _ref$dataTestSubj,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_drag_drop_context.EuiDragDropContextContext),
    isDraggingType = _useContext.isDraggingType;
  var dropIsDisabled = cloneDraggables ? true : isDropDisabled;
  var styles = (0, _services.useEuiMemoizedStyles)(_droppable.euiDroppableStyles);
  return (0, _react2.jsx)(_dnd.Droppable, _extends({
    isDropDisabled: dropIsDisabled,
    droppableId: droppableId,
    direction: direction,
    type: type
  }, rest), function (provided, snapshot) {
    var isDraggingOver = snapshot.isDraggingOver;
    var PanelOrDiv = withPanel ? _panel.EuiPanel : 'div';
    var panelOrDivProps = withPanel ? {
      panelRef: provided.innerRef,
      hasShadow: true,
      paddingSize: 'none'
    } : {
      ref: provided.innerRef
    };
    var cssStyles = [styles.euiDroppable, isDraggingType === type && !dropIsDisabled && styles.isDragging, isDraggingOver && styles.isDraggingOver, grow ? styles.grow : styles.noGrow, styles.spacing[spacing]];
    var classes = (0, _classnames.default)('euiDroppable', {
      'euiDroppable-isDisabled': dropIsDisabled
    }, className);
    var DroppableElement = typeof children === 'function' ? children(provided, snapshot) : children;
    return (0, _react2.jsx)(PanelOrDiv, _extends({}, provided.droppableProps, panelOrDivProps, {
      style: style,
      "data-test-subj": dataTestSubj,
      className: classes,
      css: cssStyles
    }), (0, _react2.jsx)(EuiDroppableContext.Provider, {
      value: {
        cloneItems: cloneDraggables
      }
    }, DroppableElement), (0, _react2.jsx)("div", {
      className: "euiDroppable__placeholder",
      hidden: cloneDraggables
    }, provided.placeholder));
  });
};
EuiDroppable.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.arrayOf(_propTypes.default.element.isRequired).isRequired, _propTypes.default.any.isRequired]).isRequired,
  className: _propTypes.default.string,
  /**
     * Makes its items immutable. Dragging creates cloned items that can be dropped elsewhere.
     */
  cloneDraggables: _propTypes.default.bool,
  style: _propTypes.default.any,
  /**
     * Adds padding to the droppable area
     */
  spacing: _propTypes.default.any,
  /**
     * Adds an EuiPanel style to the droppable area
     */
  withPanel: _propTypes.default.bool,
  /**
     * Allow the panel to flex-grow?
     */
  grow: _propTypes.default.bool,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};