"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicators = exports.DEFAULT_PAGE_SIZE = void 0;
var _react = require("react");
var _reactQuery = require("@kbn/react-query");
var _use_inspector = require("../../../hooks/use_inspector");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_sourcerer_data_view = require("./use_sourcerer_data_view");
var _fetch_indicators = require("../services/fetch_indicators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZES = [10, 25, 50];
const DEFAULT_PAGE_SIZE = exports.DEFAULT_PAGE_SIZE = PAGE_SIZES[1];
const QUERY_ID = 'indicatorsTable';
const useIndicators = ({
  filters,
  filterQuery,
  sorting,
  timeRange
}) => {
  const {
    services: {
      data: {
        search: searchService
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    selectedPatterns
  } = (0, _use_sourcerer_data_view.useSourcererDataView)();
  const {
    inspectorAdapters
  } = (0, _use_inspector.useInspector)();
  const onChangeItemsPerPage = (0, _react.useCallback)(pageSize => setPagination(currentPagination => ({
    ...currentPagination,
    pageSize,
    pageIndex: 0
  })), []);
  const onChangePage = (0, _react.useCallback)(pageIndex => setPagination(currentPagination => ({
    ...currentPagination,
    pageIndex
  })), []);
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: DEFAULT_PAGE_SIZE,
    pageSizeOptions: PAGE_SIZES
  });

  // Go to first page after filters are changed
  (0, _react.useEffect)(() => {
    onChangePage(0);
  }, [filters, filterQuery, timeRange, sorting, onChangePage]);
  const fetchIndicators = (0, _react.useMemo)(() => (0, _fetch_indicators.createFetchIndicators)({
    searchService,
    inspectorAdapter: inspectorAdapters.requests
  }), [inspectorAdapters, searchService]);
  const {
    isLoading,
    isFetching,
    data,
    refetch,
    dataUpdatedAt
  } = (0, _reactQuery.useQuery)([QUERY_ID, {
    timeRange,
    filterQuery,
    filters,
    selectedPatterns,
    sorting,
    pagination
  }], ({
    signal,
    queryKey: [_key, queryParams]
  }) => fetchIndicators(queryParams, signal), {
    /**
     * See https://tanstack.com/query/v4/docs/guides/paginated-queries
     * This is essential for our ux
     */
    keepPreviousData: true
  });
  const query = (0, _react.useMemo)(() => ({
    refetch,
    id: QUERY_ID,
    loading: isLoading
  }), [isLoading, refetch]);
  return {
    indicators: (data === null || data === void 0 ? void 0 : data.indicators) || [],
    indicatorCount: (data === null || data === void 0 ? void 0 : data.total) || 0,
    pagination,
    onChangePage,
    onChangeItemsPerPage,
    isLoading,
    isFetching,
    dataUpdatedAt,
    query
  };
};
exports.useIndicators = useIndicators;