"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInspector = void 0;
var _react = require("react");
var _use_kibana = require("./use_kibana");
var _inspector = require("../containers/inspector");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *
 * @returns Exposes the adapters used to analyze requests and a method to open the inspector
 */
const useInspector = () => {
  const {
    services: {
      inspector
    }
  } = (0, _use_kibana.useKibana)();
  const inspectorAdapters = (0, _react.useContext)(_inspector.InspectorContext);
  if (!inspectorAdapters) {
    throw new Error('Inspector Context is not available');
  }
  const [inspectorSession, setInspectorSession] = (0, _react.useState)(undefined);
  const onOpenInspector = (0, _react.useCallback)(() => {
    const session = inspector.open(inspectorAdapters, {
      title: _translations.INSPECTOR_FLYOUT_TITLE
    });
    setInspectorSession(session);
  }, [inspectorAdapters, inspector]);
  (0, _react.useEffect)(() => {
    return () => {
      if (inspectorSession) {
        inspectorSession.close();
      }
    };
  }, [inspectorSession]);
  return {
    onOpenInspector,
    inspectorAdapters
  };
};
exports.useInspector = useInspector;