"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleRruleSchema = exports.rruleSchedule = exports.rruleCommon = exports.byweekday = exports.bymonthday = exports.byminute = exports.byhour = void 0;
exports.validateTimezone = validateTimezone;
var _configSchema = require("@kbn/config-schema");
var _rrule = require("@kbn/rrule");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateTimezone(timezone) {
  if (_momentTimezone.default.tz.zone(timezone) != null) {
    return;
  }
  return 'string is not a valid timezone: ' + timezone;
}
const validateRecurrenceByWeekday = array => {
  if (array.length === 0) {
    return 'rRule byweekday cannot be empty';
  }
  const byWeekDayRegex = new RegExp('^(((\\+|-)[1-4])?(MO|TU|WE|TH|FR|SA|SU))$');
  const invalidDays = [];
  array.forEach(day => {
    if (!byWeekDayRegex.test(day)) {
      invalidDays.push(day);
    }
  });
  if (invalidDays.length > 0) {
    return `invalid byweekday values in rRule byweekday: ${invalidDays.join(',')}`;
  }
};
const rruleCommon = exports.rruleCommon = _configSchema.schema.object({
  freq: _configSchema.schema.oneOf([_configSchema.schema.literal(0), _configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6)]),
  interval: _configSchema.schema.number({
    validate: interval => {
      if (!Number.isInteger(interval)) {
        return 'rRule interval must be an integer greater than 0';
      }
    },
    min: 1
  }),
  tzid: _configSchema.schema.string({
    validate: validateTimezone,
    defaultValue: 'UTC'
  })
});
const byminute = exports.byminute = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
  min: 0,
  max: 59
}), {
  minSize: 1
}));
const byhour = exports.byhour = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
  min: 0,
  max: 23
}), {
  minSize: 1
}));
const byweekday = exports.byweekday = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
  minSize: 1,
  validate: validateRecurrenceByWeekday
}));
const bymonthday = exports.bymonthday = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
  min: 1,
  max: 31
}), {
  minSize: 1
}));
const rruleMonthly = rruleCommon.extends({
  freq: _configSchema.schema.literal(_rrule.Frequency.MONTHLY),
  byhour,
  byminute,
  byweekday,
  bymonthday
});
const rruleWeekly = rruleCommon.extends({
  freq: _configSchema.schema.literal(_rrule.Frequency.WEEKLY),
  byhour,
  byminute,
  byweekday,
  bymonthday: _configSchema.schema.never()
});
const rruleDaily = rruleCommon.extends({
  freq: _configSchema.schema.literal(_rrule.Frequency.DAILY),
  byhour,
  byminute,
  byweekday,
  bymonthday: _configSchema.schema.never()
});
const rruleSchedule = exports.rruleSchedule = _configSchema.schema.oneOf([rruleMonthly, rruleWeekly, rruleDaily]);
const scheduleRruleSchema = exports.scheduleRruleSchema = _configSchema.schema.object({
  rrule: rruleSchedule
});