"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectLocationMonitors = exports.selectDynamicSettings = exports.selectAgentPolicies = exports.selectAddingNewPrivateLocation = void 0;
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectDynamicSettings = state => state.dynamicSettings;
exports.selectDynamicSettings = selectDynamicSettings;
const getState = appState => appState.agentPolicies;
const selectAgentPolicies = exports.selectAgentPolicies = (0, _reselect.createSelector)(getState, state => state);
const selectAddingNewPrivateLocation = state => {
  var _state$privateLocatio;
  return (_state$privateLocatio = state.privateLocations.isPrivateLocationFlyoutVisible) !== null && _state$privateLocatio !== void 0 ? _state$privateLocatio : false;
};
exports.selectAddingNewPrivateLocation = selectAddingNewPrivateLocation;
const selectLocationMonitors = state => ({
  locationMonitors: state.dynamicSettings.locationMonitors,
  loading: state.dynamicSettings.locationMonitorsLoading
});
exports.selectLocationMonitors = selectLocationMonitors;