"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setCertificatesTotalAction = exports.certificatesSelector = exports.certificatesReducer = void 0;
var _reduxActions = require("redux-actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setCertificatesTotalAction = exports.setCertificatesTotalAction = (0, _reduxActions.createAction)('SET_CERTIFICATES_TOTAL');
const initialState = {
  total: 0
};
const certificatesReducer = exports.certificatesReducer = (0, _reduxActions.handleActions)({
  [String(setCertificatesTotalAction)]: (state, action) => ({
    ...state,
    total: action.payload.total
  })
}, initialState);
const certificatesSelector = ({
  certificates
}) => certificates.total;
exports.certificatesSelector = certificatesSelector;