"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestError = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _contexts = require("../../../../../contexts");
var _state = require("../../../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLatestError = ({
  monitorId,
  locationLabel,
  configIdByLocation
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const isPopoverOpen = (0, _reactRedux.useSelector)(_state.selectErrorPopoverState);
  const {
    data: latestPing,
    loading
  } = (0, _reactRedux.useSelector)(_state.selectLastErrorRunMetadata);
  (0, _react.useEffect)(() => {
    if (monitorId && locationLabel && isPopoverOpen === configIdByLocation) {
      dispatch(_state.getMonitorLastErrorRunAction.get({
        monitorId,
        locationLabel
      }));
    }
  }, [dispatch, monitorId, locationLabel, lastRefresh, isPopoverOpen, configIdByLocation]);
  return {
    loading,
    latestPing
  };
};
exports.useLatestError = useLatestError;