"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsertStreamQueryRequestSchema = exports.streamQuerySchema = exports.streamQueryKqlSchema = exports.querySchema = exports.isStreamQueryKql = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _record_types = require("../shared/record_types");
var _type_guards = require("../shared/type_guards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const streamQueryBaseSchema = _zod.z.object({
  id: _zodHelpers.NonEmptyString,
  title: _zodHelpers.NonEmptyString
});
const streamQueryKqlSchema = exports.streamQueryKqlSchema = _zod.z.intersection(streamQueryBaseSchema, _zod.z.object({
  kql: _zod.z.object({
    query: _zodHelpers.NonEmptyString
  })
}));
const querySchema = exports.querySchema = _zod.z.lazy(() => _zod.z.record(_zod.z.union([_record_types.primitive, _zod.z.array(_zod.z.union([_record_types.primitive, querySchema])), querySchema])));
const streamQuerySchema = exports.streamQuerySchema = streamQueryKqlSchema;
const upsertStreamQueryRequestSchema = exports.upsertStreamQueryRequestSchema = _zod.z.object({
  title: _zodHelpers.NonEmptyString,
  kql: _zod.z.object({
    query: _zodHelpers.NonEmptyString
  })
});
const isStreamQueryKql = exports.isStreamQueryKql = (0, _type_guards.createIsNarrowSchema)(streamQuerySchema, streamQueryKqlSchema);