"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.geoIpProcessorDefinitionSchema = exports.dissectProcessorDefinitionSchema = exports.dateProcessorDefinitionSchema = void 0;
exports.getProcessorConfig = getProcessorConfig;
exports.getProcessorType = getProcessorType;
exports.userAgentProcessorDefinitionSchema = exports.urlDecodeProcessorDefinitionSchema = exports.setProcessorDefinitionSchema = exports.renameProcessorDefinitionSchema = exports.processorWithIdDefinitionSchema = exports.processorDefinitionSchema = exports.manualIngestPipelineProcessorDefinitionSchema = exports.kvProcessorDefinitionSchema = exports.isGrokProcessorDefinition = exports.isDissectProcessorDefinition = exports.isDateProcessorDefinition = exports.grokProcessorDefinitionSchema = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _ingest_pipeline_processors = require("../../../ingest_pipeline_processors");
var _conditions = require("../../../conditions");
var _type_guards = require("../../../shared/type_guards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Base processor
 */

const processorBaseSchema = _zod.z.object({
  description: _zod.z.optional(_zod.z.string()),
  if: _zod.z.optional(_conditions.conditionSchema),
  ignore_failure: _zod.z.optional(_zod.z.boolean())
});

/* Manual ingest pipeline processor */

// Not 100% accurate, but close enough for our use case to provide minimal safety
// without having to check all details

const manualIngestPipelineProcessorDefinitionSchema = exports.manualIngestPipelineProcessorDefinitionSchema = _zod.z.strictObject({
  manual_ingest_pipeline: _zod.z.intersection(processorBaseSchema, _zod.z.object({
    processors: _zod.z.array(_zod.z.record(_zod.z.enum(_ingest_pipeline_processors.elasticsearchProcessorTypes), _zod.z.unknown())),
    tag: _zod.z.optional(_zod.z.string()),
    on_failure: _zod.z.optional(_zod.z.array(_zod.z.record(_zod.z.unknown())))
  }))
});

/**
 * Grok processor
 */

const grokProcessorDefinitionSchema = exports.grokProcessorDefinitionSchema = _zod.z.strictObject({
  grok: _zod.z.intersection(processorBaseSchema, _zod.z.object({
    field: _zodHelpers.NonEmptyString,
    patterns: _zod.z.array(_zodHelpers.NonEmptyString).nonempty(),
    pattern_definitions: _zod.z.optional(_zod.z.record(_zod.z.string())),
    ignore_missing: _zod.z.optional(_zod.z.boolean())
  }))
});

/**
 * Dissect processor
 */

const dissectProcessorDefinitionSchema = exports.dissectProcessorDefinitionSchema = _zod.z.strictObject({
  dissect: _zod.z.intersection(processorBaseSchema, _zod.z.object({
    field: _zodHelpers.NonEmptyString,
    pattern: _zodHelpers.NonEmptyString,
    append_separator: _zod.z.optional(_zodHelpers.NonEmptyString),
    ignore_missing: _zod.z.optional(_zod.z.boolean())
  }))
});

/**
 * Date processor
 */

const dateProcessorDefinitionSchema = exports.dateProcessorDefinitionSchema = _zod.z.strictObject({
  date: _zod.z.intersection(processorBaseSchema, _zod.z.object({
    field: _zodHelpers.NonEmptyString,
    formats: _zod.z.array(_zodHelpers.NonEmptyString),
    locale: _zod.z.optional(_zodHelpers.NonEmptyString),
    target_field: _zod.z.optional(_zodHelpers.NonEmptyString),
    timezone: _zod.z.optional(_zodHelpers.NonEmptyString),
    output_format: _zod.z.optional(_zodHelpers.NonEmptyString)
  }))
});

/**
 * KV processor
 */

const kvProcessorDefinitionSchema = exports.kvProcessorDefinitionSchema = _zod.z.strictObject({
  kv: _zod.z.intersection(processorBaseSchema, _zod.z.object({
    field: _zodHelpers.NonEmptyString,
    // These aren't NonEmptyString on purpose as a space (for example) can be a valid use case here.
    field_split: _zod.z.string(),
    value_split: _zod.z.string(),
    target_field: _zod.z.optional(_zodHelpers.NonEmptyString),
    include_keys: _zod.z.optional(_zod.z.array(_zodHelpers.NonEmptyString)),
    exclude_keys: _zod.z.optional(_zod.z.array(_zodHelpers.NonEmptyString)),
    ignore_missing: _zod.z.optional(_zod.z.boolean()),
    prefix: _zod.z.optional(_zodHelpers.NonEmptyString),
    trim_key: _zod.z.optional(_zodHelpers.NonEmptyString),
    trim_value: _zod.z.optional(_zodHelpers.NonEmptyString),
    strip_brackets: _zod.z.optional(_zod.z.boolean())
  }))
});

/**
 * GeoIP processor
 */

const geoIpProcessorDefinitionSchema = exports.geoIpProcessorDefinitionSchema = _zod.z.strictObject({
  geoip: _zod.z.object({
    field: _zodHelpers.NonEmptyString,
    target_field: _zod.z.optional(_zodHelpers.NonEmptyString),
    database_file: _zod.z.optional(_zodHelpers.NonEmptyString),
    properties: _zod.z.optional(_zod.z.array(_zodHelpers.NonEmptyString)),
    ignore_missing: _zod.z.optional(_zod.z.boolean()),
    first_only: _zod.z.optional(_zod.z.boolean())
  })
});

/**
 * Rename processor
 */

const renameProcessorDefinitionSchema = exports.renameProcessorDefinitionSchema = _zod.z.strictObject({
  rename: _zod.z.intersection(processorBaseSchema, _zod.z.object({
    field: _zodHelpers.NonEmptyString,
    target_field: _zodHelpers.NonEmptyString,
    ignore_missing: _zod.z.optional(_zod.z.boolean()),
    override: _zod.z.optional(_zod.z.boolean())
  }))
});

/**
 * Set processor
 */

const setProcessorDefinitionSchema = exports.setProcessorDefinitionSchema = _zod.z.strictObject({
  set: _zod.z.intersection(processorBaseSchema, _zod.z.object({
    field: _zodHelpers.NonEmptyString,
    value: _zodHelpers.NonEmptyString,
    override: _zod.z.optional(_zod.z.boolean()),
    ignore_empty_value: _zod.z.optional(_zod.z.boolean()),
    media_type: _zod.z.optional(_zod.z.string())
  }))
});

/**
 * URL Decode processor
 */

const urlDecodeProcessorDefinitionSchema = exports.urlDecodeProcessorDefinitionSchema = _zod.z.strictObject({
  urldecode: _zod.z.intersection(processorBaseSchema, _zod.z.object({
    field: _zodHelpers.NonEmptyString,
    target_field: _zod.z.optional(_zodHelpers.NonEmptyString),
    ignore_missing: _zod.z.optional(_zod.z.boolean())
  }))
});

/**
 * User agent processor
 */

const userAgentProcessorDefinitionSchema = exports.userAgentProcessorDefinitionSchema = _zod.z.strictObject({
  user_agent: _zod.z.object({
    field: _zodHelpers.NonEmptyString,
    target_field: _zod.z.optional(_zodHelpers.NonEmptyString),
    regex_file: _zod.z.optional(_zodHelpers.NonEmptyString),
    properties: _zod.z.optional(_zod.z.array(_zodHelpers.NonEmptyString)),
    ignore_missing: _zod.z.optional(_zod.z.boolean())
  })
});
const processorDefinitionSchema = exports.processorDefinitionSchema = _zod.z.union([dateProcessorDefinitionSchema, dissectProcessorDefinitionSchema, grokProcessorDefinitionSchema, manualIngestPipelineProcessorDefinitionSchema, kvProcessorDefinitionSchema, geoIpProcessorDefinitionSchema, renameProcessorDefinitionSchema, setProcessorDefinitionSchema, urlDecodeProcessorDefinitionSchema, userAgentProcessorDefinitionSchema]);
const processorWithIdDefinitionSchema = exports.processorWithIdDefinitionSchema = _zod.z.union([dateProcessorDefinitionSchema.merge(_zod.z.object({
  id: _zod.z.string()
})), dissectProcessorDefinitionSchema.merge(_zod.z.object({
  id: _zod.z.string()
})), grokProcessorDefinitionSchema.merge(_zod.z.object({
  id: _zod.z.string()
})), manualIngestPipelineProcessorDefinitionSchema.merge(_zod.z.object({
  id: _zod.z.string()
})), kvProcessorDefinitionSchema.merge(_zod.z.object({
  id: _zod.z.string()
})), geoIpProcessorDefinitionSchema.merge(_zod.z.object({
  id: _zod.z.string()
})), renameProcessorDefinitionSchema.merge(_zod.z.object({
  id: _zod.z.string()
})), setProcessorDefinitionSchema.merge(_zod.z.object({
  id: _zod.z.string()
})), urlDecodeProcessorDefinitionSchema.merge(_zod.z.object({
  id: _zod.z.string()
})), userAgentProcessorDefinitionSchema.merge(_zod.z.object({
  id: _zod.z.string()
}))]);
const isGrokProcessorDefinition = exports.isGrokProcessorDefinition = (0, _type_guards.createIsNarrowSchema)(processorDefinitionSchema, grokProcessorDefinitionSchema);
const isDissectProcessorDefinition = exports.isDissectProcessorDefinition = (0, _type_guards.createIsNarrowSchema)(processorDefinitionSchema, dissectProcessorDefinitionSchema);
const isDateProcessorDefinition = exports.isDateProcessorDefinition = (0, _type_guards.createIsNarrowSchema)(processorDefinitionSchema, dateProcessorDefinitionSchema);
const processorTypes = processorDefinitionSchema.options.map(option => Object.keys(option.shape)[0]);
function getProcessorType(processor) {
  return processorTypes.find(type => type in processor);
}
function getProcessorConfig(processor) {
  const type = getProcessorType(processor);
  return processor[type];
}