"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsListEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _asset_image = require("../asset_image");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StreamsListEmptyPrompt = ({
  onAddData
}) => {
  const {
    core: {
      docLinks
    }
  } = (0, _use_kibana.useKibana)();
  const streamsDocsLink = docLinks.links.observability.logsStreams;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasBorder: true,
    css: {
      maxWidth: 760,
      border: `${_uiTheme.euiThemeVars.euiBorderWidthThin} solid ${_uiTheme.euiThemeVars.euiBorderColor}`,
      borderRadius: _uiTheme.euiThemeVars.euiBorderRadius
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      padding: _uiTheme.euiThemeVars.euiSizeL
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9,
    css: {
      paddingTop: _uiTheme.euiThemeVars.euiSizeL,
      paddingBottom: _uiTheme.euiThemeVars.euiSizeL
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.streams.emptyState.title', {
    defaultMessage: 'Turn raw data into structured, manageable streams'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, _i18n.i18n.translate('xpack.streams.emptyState.body', {
    defaultMessage: 'Easily turn your data into clear, structured flows with simple tools for routing, field extraction, and retention. Just stream it into Elastic to get started and your new streams will appear here.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    minWidth: false,
    css: {
      padding: `${_uiTheme.euiThemeVars.euiSizeM} ${_uiTheme.euiThemeVars.euiSizeL}`,
      alignSelf: 'flex-start',
      fontWeight: 'normal',
      marginTop: _uiTheme.euiThemeVars.euiSizeS
    },
    onClick: onAddData
  }, _i18n.i18n.translate('xpack.streams.emptyState.addDataButton', {
    defaultMessage: 'Add data'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 10
  }, /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
    type: "addStreams"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      backgroundColor: _uiTheme.euiThemeVars.euiColorBackgroundBaseSubdued,
      padding: _uiTheme.euiThemeVars.euiSizeL,
      borderBottomLeftRadius: _uiTheme.euiThemeVars.euiBorderRadius,
      borderBottomRightRadius: _uiTheme.euiThemeVars.euiBorderRadius,
      border: 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: {
      fontWeight: _uiTheme.euiThemeVars.euiFontWeightMedium
    }
  }, _i18n.i18n.translate('xpack.streams.emptyState.learnMore', {
    defaultMessage: 'Want to learn more? '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: streamsDocsLink,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.streams.emptyState.learnMore.link', {
    defaultMessage: ' Read our Streams documentation'
  }))))));
};
exports.StreamsListEmptyPrompt = StreamsListEmptyPrompt;