"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamChartPanel = StreamChartPanel;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _visualizationUtils = require("@kbn/visualization-utils");
var _moment = _interopRequireDefault(require("moment"));
var _use_kibana = require("../../../hooks/use_kibana");
var _controlled_esql_chart = require("../../esql_chart/controlled_esql_chart");
var _hierarchy_helpers = require("../../../util/hierarchy_helpers");
var _streams_app_search_bar = require("../../streams_app_search_bar");
var _use_streams_app_fetch = require("../../../hooks/use_streams_app_fetch");
var _use_timefilter = require("../../../hooks/use_timefilter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamChartPanel({
  definition
}) {
  var _docCountFetch$value;
  const {
    dependencies: {
      start: {
        data,
        dataViews,
        streams: {
          streamsRepositoryClient
        },
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const indexPatterns = (0, _react.useMemo)(() => {
    return (0, _hierarchy_helpers.getIndexPatterns)(definition === null || definition === void 0 ? void 0 : definition.stream);
  }, [definition]);
  const discoverLocator = (0, _react.useMemo)(() => share.url.locators.get('DISCOVER_APP_LOCATOR'), [share.url.locators]);
  const bucketSize = (0, _react.useMemo)(() => (0, _visualizationUtils.computeInterval)(timeState.asAbsoluteTimeRange, data), [data, timeState.asAbsoluteTimeRange]);
  const queries = (0, _react.useMemo)(() => {
    if (!indexPatterns) {
      return undefined;
    }
    const baseQuery = `FROM ${indexPatterns.join(', ')}`;
    const histogramQuery = `${baseQuery} | STATS metric = COUNT(*) BY @timestamp = BUCKET(@timestamp, ${bucketSize})`;
    return {
      baseQuery,
      histogramQuery
    };
  }, [bucketSize, indexPatterns]);
  const discoverLink = (0, _react.useMemo)(() => {
    if (!discoverLocator || !(queries !== null && queries !== void 0 && queries.baseQuery)) {
      return undefined;
    }
    return discoverLocator.getRedirectUrl({
      query: {
        esql: queries.baseQuery
      }
    });
  }, [queries === null || queries === void 0 ? void 0 : queries.baseQuery, discoverLocator]);
  const histogramQueryFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal,
    timeState: {
      start,
      end
    }
  }) => {
    if (!(queries !== null && queries !== void 0 && queries.histogramQuery) || !indexPatterns) {
      return undefined;
    }
    const existingIndices = await dataViews.getExistingIndices(indexPatterns);
    if (existingIndices.length === 0) {
      return undefined;
    }
    return streamsRepositoryClient.fetch('POST /internal/streams/esql', {
      params: {
        body: {
          operationName: 'get_histogram_for_stream',
          query: queries.histogramQuery,
          start,
          end
        }
      },
      signal
    });
  }, [indexPatterns, dataViews, streamsRepositoryClient, queries === null || queries === void 0 ? void 0 : queries.histogramQuery], {
    withTimeRange: true
  });
  const docCountFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal,
    timeState: {
      asAbsoluteTimeRange: {
        from,
        to
      }
    }
  }) => {
    if (!definition) {
      return undefined;
    }
    return streamsRepositoryClient.fetch('GET /internal/streams/{name}/_details', {
      signal,
      params: {
        path: {
          name: definition.stream.name
        },
        query: {
          start: from,
          end: to
        }
      }
    });
  }, [definition, streamsRepositoryClient], {
    withTimeRange: true
  });
  const [value, unit] = bucketSize.split(' ');
  const xDomain = {
    min: timeState.start,
    max: timeState.end,
    minInterval: _moment.default.duration(value, unit).asMilliseconds()
  };
  const docCount = docCountFetch === null || docCountFetch === void 0 ? void 0 : (_docCountFetch$value = docCountFetch.value) === null || _docCountFetch$value === void 0 ? void 0 : _docCountFetch$value.details.count;
  const formattedDocCount = docCount ? (0, _eui.formatNumber)(docCount, 'decimal0') : '0';
  const dataStreamExists = _streamsSchema.Streams.WiredStream.GetResponse.is(definition) || definition.data_stream_exists;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: (0, _css.css)`
          height: 100%;
          min-height: 300px;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.streams.streamDetailOverview.logRate', {
    defaultMessage: '{number} documents',
    values: {
      number: formattedDocCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsDetailOverviewOpenInDiscoverButton",
    iconType: "discoverApp",
    href: discoverLink,
    isDisabled: !discoverLink || !dataStreamExists
  }, _i18n.i18n.translate('xpack.streams.streamDetailOverview.openInDiscoverButtonLabel', {
    defaultMessage: 'Open in Discover'
  })), /*#__PURE__*/_react.default.createElement(_streams_app_search_bar.StreamsAppSearchBar, {
    placeholder: _i18n.i18n.translate('xpack.streams.entityDetailOverview.searchBarPlaceholder', {
      defaultMessage: 'Filter data by using KQL'
    }),
    showDatePicker: true
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_controlled_esql_chart.ControlledEsqlChart, {
    result: histogramQueryFetch,
    id: "entity_log_rate",
    metricNames: ['metric'],
    chartType: 'bar',
    xDomain: xDomain
  }))));
}