"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlledEsqlChart = ControlledEsqlChart;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _public = require("@kbn/data-plugin/public");
var _esql_result_to_timeseries = require("../../util/esql_result_to_timeseries");
var _use_kibana = require("../../hooks/use_kibana");
var _loading_panel = require("../loading_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTimeZone(uiSettings) {
  const kibanaTimeZone = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_public.UI_SETTINGS.DATEFORMAT_TZ);
  if (!kibanaTimeZone || kibanaTimeZone === 'Browser') {
    return 'local';
  }
  return kibanaTimeZone;
}
const END_ZONE_LABEL = _i18n.i18n.translate('xpack.streams.esqlChart.endzone', {
  defaultMessage: 'The selected time range does not include this entire bucket. It might contain partial data.'
});
function getChartType(type) {
  switch (type) {
    case 'area':
      return _charts.AreaSeries;
    case 'bar':
      return _charts.BarSeries;
    default:
      return _charts.LineSeries;
  }
}
function ControlledEsqlChart({
  id,
  result,
  metricNames,
  chartType = 'line',
  height,
  xDomain: customXDomain
}) {
  var _result$value, _customXDomain$min, _customXDomain$max;
  const {
    core: {
      uiSettings
    }
  } = (0, _use_kibana.useKibana)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const allTimeseries = (0, _react.useMemo)(() => (0, _esql_result_to_timeseries.esqlResultToTimeseries)({
    result,
    metricNames
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [result, ...metricNames]);
  const effectiveHeight = height ? `${height}px` : '100%';
  if (result.loading && !((_result$value = result.value) !== null && _result$value !== void 0 && _result$value.values.length)) {
    return /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, {
      loading: true,
      className: (0, _css.css)`
          height: ${effectiveHeight};
        `
    });
  }
  const xValues = allTimeseries.flatMap(({
    data
  }) => data.map(({
    x
  }) => x));

  // todo - pull in time range here
  const min = (_customXDomain$min = customXDomain === null || customXDomain === void 0 ? void 0 : customXDomain.min) !== null && _customXDomain$min !== void 0 ? _customXDomain$min : Math.min(...xValues);
  const max = (_customXDomain$max = customXDomain === null || customXDomain === void 0 ? void 0 : customXDomain.max) !== null && _customXDomain$max !== void 0 ? _customXDomain$max : Math.max(...xValues);
  const isEmpty = min === 0 && max === 0;
  const xFormatter = (0, _charts.niceTimeFormatter)([min, max]);
  const xDomain = isEmpty ? {
    min: 0,
    max: 1
  } : {
    min,
    max,
    minInterval: customXDomain === null || customXDomain === void 0 ? void 0 : customXDomain.minInterval
  };
  const yTickFormat = value => value === null ? '' : String(value);
  const yLabelFormat = label => label;
  const timeZone = getTimeZone(uiSettings);
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    id: id,
    className: (0, _css.css)`
        height: ${effectiveHeight};
      `
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    stickTo: "top",
    showNullValues: false,
    headerFormatter: ({
      value
    }) => {
      const formattedValue = xFormatter(value);
      if (max === value) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          responsive: false,
          gutterSize: "xs",
          style: {
            fontWeight: 'normal'
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "info"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, END_ZONE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "xs"
        }), formattedValue);
      }
      return formattedValue;
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    legendPosition: _charts.Position.Bottom,
    xDomain: xDomain,
    locale: _i18n.i18n.getLocale(),
    baseTheme: chartBaseTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: xFormatter,
    gridLine: {
      visible: false
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    ticks: 3,
    position: _charts.Position.Left,
    hide: true,
    tickFormat: yTickFormat,
    labelFormat: yLabelFormat
  }), allTimeseries.map(serie => {
    const Series = getChartType(chartType);
    return /*#__PURE__*/_react.default.createElement(Series, {
      timeZone: timeZone,
      key: serie.id,
      color: "#61A2FF",
      id: serie.id
      // Defaults to multi layer time axis as of Elastic Charts v70
      ,
      xScaleType: _charts.ScaleType.Time,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: "x",
      yAccessors: serie.metricNames,
      data: serie.data,
      curve: _charts.CurveType.CURVE_MONOTONE_X
    });
  }));
}