"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailManagement = StreamDetailManagement;
var _react = _interopRequireDefault(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _use_stream_detail = require("../../../hooks/use_stream_detail");
var _wired = require("./wired");
var _classic = require("./classic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamDetailManagement() {
  const {
    definition,
    refresh
  } = (0, _use_stream_detail.useStreamDetail)();
  if (_streamsSchema.Streams.WiredStream.GetResponse.is(definition)) {
    return /*#__PURE__*/_react.default.createElement(_wired.WiredStreamDetailManagement, {
      definition: definition,
      refreshDefinition: refresh
    });
  }
  return /*#__PURE__*/_react.default.createElement(_classic.ClassicStreamDetailManagement, {
    definition: definition,
    refreshDefinition: refresh
  });
}