"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataStreamStats = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../../../hooks/use_streams_app_fetch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataStreamStats = ({
  definition
}) => {
  const {
    services: {
      dataStreamsClient
    }
  } = (0, _use_kibana.useKibana)();
  const statsFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(async () => {
    const client = await dataStreamsClient;
    const {
      dataStreamsStats: [dsStats]
    } = await client.getDataStreamsStats({
      datasetQuery: definition.stream.name,
      includeCreationDate: true
    });
    if (!dsStats || !dsStats.creationDate) {
      return undefined;
    }
    const daysSinceCreation = Math.max(1, Math.round((0, _moment.default)().diff((0, _moment.default)(dsStats.creationDate), 'days')));
    return {
      ...dsStats,
      bytesPerDay: dsStats.sizeBytes ? dsStats.sizeBytes / daysSinceCreation : 0,
      bytesPerDoc: dsStats.totalDocs && dsStats.sizeBytes ? dsStats.sizeBytes / dsStats.totalDocs : 0
    };
  }, [dataStreamsClient, definition], {
    withTimeRange: false,
    withRefresh: true
  });
  return {
    stats: statsFetch.value,
    isLoading: statsFetch.loading,
    refresh: statsFetch.refresh,
    error: statsFetch.error
  };
};
exports.useDataStreamStats = useDataStreamStats;