"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultRandomSamplesDataSource = exports.defaultKqlSamplesDataSource = exports.defaultEnrichmentUrlState = exports.defaultCustomSamplesDataSource = void 0;
exports.getConfiguredProcessors = getConfiguredProcessors;
exports.getDataSourcesSamples = getDataSourcesSamples;
exports.getDataSourcesUrlState = getDataSourcesUrlState;
exports.getStagedProcessors = getStagedProcessors;
exports.getUpsertWiredFields = getUpsertWiredFields;
exports.spawnDataSource = void 0;
var _streamsSchema = require("@kbn/streams-schema");
var _i18n = require("@kbn/i18n");
var _simulation_state_machine = require("../simulation_state_machine");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultRandomSamplesDataSource = exports.defaultRandomSamplesDataSource = {
  type: 'random-samples',
  name: _i18n.i18n.translate('xpack.streams.enrichment.dataSources.randomSamples.defaultName', {
    defaultMessage: 'Random samples'
  }),
  enabled: true
};
const defaultKqlSamplesDataSource = exports.defaultKqlSamplesDataSource = {
  type: 'kql-samples',
  name: '',
  enabled: true,
  timeRange: {
    from: 'now-15m',
    to: 'now'
  },
  filters: [],
  query: {
    language: 'kuery',
    query: ''
  }
};
const defaultCustomSamplesDataSource = exports.defaultCustomSamplesDataSource = {
  type: 'custom-samples',
  name: '',
  enabled: true,
  documents: []
};
const defaultEnrichmentUrlState = exports.defaultEnrichmentUrlState = {
  v: 1,
  dataSources: [defaultRandomSamplesDataSource]
};
function getDataSourcesUrlState(context) {
  const dataSources = context.dataSourcesRefs.map(dataSourceRef => dataSourceRef.getSnapshot().context.dataSource);
  return dataSources.filter(dataSource => dataSource.type !== 'custom-samples') // Custom samples are not stored in the URL
  .map(_utils.dataSourceConverter.toUrlSchema);
}
function getDataSourcesSamples(context) {
  const dataSourcesSnapshots = context.dataSourcesRefs.map(dataSourceRef => dataSourceRef.getSnapshot()).filter(snapshot => snapshot.matches('enabled'));
  return dataSourcesSnapshots.flatMap(snapshot => snapshot.context.data);
}
function getStagedProcessors(context) {
  return context.processorsRefs.map(proc => proc.getSnapshot()).filter(proc => proc.context.isNew).map(proc => proc.context.processor);
}
function getConfiguredProcessors(context) {
  return context.processorsRefs.map(proc => proc.getSnapshot()).filter(proc => proc.matches('configured')).map(proc => proc.context.processor);
}
function getUpsertWiredFields(context) {
  if (!_streamsSchema.Streams.WiredStream.GetResponse.is(context.definition) || !context.simulatorRef) {
    return undefined;
  }
  const originalFieldDefinition = {
    ...context.definition.stream.ingest.wired.fields
  };
  const {
    detectedSchemaFields
  } = context.simulatorRef.getSnapshot().context;

  // Remove unmapped fields from original definition
  const unmappedSchemaFields = (0, _simulation_state_machine.getUnmappedSchemaFields)(detectedSchemaFields);
  unmappedSchemaFields.forEach(field => {
    delete originalFieldDefinition[field.name];
  });
  const mappedSchemaFields = (0, _simulation_state_machine.getMappedSchemaFields)(detectedSchemaFields).filter(field => !originalFieldDefinition[field.name]);
  const simulationMappedFieldDefinition = (0, _simulation_state_machine.convertToFieldDefinition)(mappedSchemaFields);
  return {
    ...originalFieldDefinition,
    ...simulationMappedFieldDefinition
  };
}
const spawnDataSource = (dataSource, assignArgs) => {
  const {
    spawn,
    context,
    self
  } = assignArgs;
  const dataSourceWithUIAttributes = _utils.dataSourceConverter.toUIDefinition(dataSource);
  return spawn('dataSourceMachine', {
    id: dataSourceWithUIAttributes.id,
    input: {
      parentRef: self,
      streamName: context.definition.stream.name,
      dataSource: dataSourceWithUIAttributes
    }
  });
};
exports.spawnDataSource = spawnDataSource;