"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.api = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validChannelIdHandler = async ({
  externalService,
  params: {
    channelId
  }
}) => await externalService.validChannelId(channelId !== null && channelId !== void 0 ? channelId : '');
const postMessageHandler = async ({
  externalService,
  params: {
    channelIds,
    channels,
    text
  }
}) => await externalService.postMessage({
  channelIds,
  channels,
  text
});
const postBlockkitHandler = async ({
  externalService,
  params: {
    channelIds,
    channels,
    text
  }
}) => await externalService.postBlockkit({
  channelIds,
  channels,
  text
});
const api = exports.api = {
  validChannelId: validChannelIdHandler,
  postMessage: postMessageHandler,
  postBlockkit: postBlockkitHandler
};