"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSLOResponseSchema = exports.createSLOParamsSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _schema = require("../../schema");
var _common = require("../../schema/common");
var _slo = require("../../schema/slo");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSLOParamsSchema = exports.createSLOParamsSchema = t.type({
  body: t.intersection([t.type({
    name: t.string,
    description: t.string,
    indicator: _schema.indicatorSchema,
    timeWindow: _schema.timeWindowSchema,
    budgetingMethod: _slo.budgetingMethodSchema,
    objective: _slo.objectiveSchema
  }), t.partial({
    id: _slo.sloIdSchema,
    settings: _slo.optionalSettingsSchema,
    tags: _slo.tagsSchema,
    groupBy: _common.allOrAnyStringOrArray,
    revision: t.number
  })])
});
const createSLOResponseSchema = exports.createSLOResponseSchema = t.type({
  id: _slo.sloIdSchema
});

// Raw payload sent by the frontend
// Parsed payload used by the backend
// Raw response sent to the frontend