"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSloSummaryDataView = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _react = require("react");
var _get_slo_summary_indices = require("../../../../common/get_slo_summary_indices");
var _use_create_data_view = require("../../../hooks/use_create_data_view");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_get_settings = require("../../slo_settings/hooks/use_get_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSloSummaryDataView = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const [indexPattern, setIndexPattern] = (0, _react.useState)();
  const {
    isLoading: isSettingsLoading,
    data: settings
  } = (0, _use_get_settings.useGetSettings)();
  const {
    loading: isRemoteClustersLoading,
    data: remoteClusters
  } = (0, _public.useFetcher)(() => {
    return http === null || http === void 0 ? void 0 : http.get('/api/remote_clusters');
  }, [http]);
  (0, _react.useEffect)(() => {
    if (settings && remoteClusters) {
      const summaryIndices = (0, _get_slo_summary_indices.getSLOSummaryIndices)(settings, remoteClusters);
      setIndexPattern(summaryIndices.join(','));
    }
  }, [settings, remoteClusters]);
  const {
    loading: isDataViewLoading,
    dataView
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: indexPattern
  });
  return {
    isLoading: isSettingsLoading || isRemoteClustersLoading || isDataViewLoading,
    data: dataView
  };
};
exports.useSloSummaryDataView = useSloSummaryDataView;