"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOSortBy = SLOSortBy;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _slo_context_menu = require("../slo_context_menu");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SLOSortBy({
  state,
  onStateChange,
  loading
}) {
  var _sortByOptions$find;
  const [isSortByPopoverOpen, setIsSortByPopoverOpen] = (0, _react.useState)(false);
  const sortBy = state.sort.by;
  const handleChangeSortBy = ({
    value,
    label
  }) => {
    onStateChange({
      page: 0,
      sort: {
        by: value,
        direction: state.sort.direction
      }
    });
  };
  const sortByOptions = [{
    label: _i18n.i18n.translate('xpack.slo.list.sortBy.sliValue', {
      defaultMessage: 'SLI value'
    }),
    checked: sortBy === 'sli_value',
    value: 'sli_value',
    onClick: () => {
      handleChangeSortBy({
        value: 'sli_value',
        label: _i18n.i18n.translate('xpack.slo.list.sortBy.sliValue', {
          defaultMessage: 'SLI value'
        })
      });
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.sortBy.sloStatus', {
      defaultMessage: 'SLO status'
    }),
    checked: sortBy === 'status',
    value: 'status',
    onClick: () => {
      handleChangeSortBy({
        value: 'status',
        label: _i18n.i18n.translate('xpack.slo.list.sortBy.sloStatus', {
          defaultMessage: 'SLO status'
        })
      });
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.sortBy.errorBudgetConsumed', {
      defaultMessage: 'Error budget consumed'
    }),
    checked: sortBy === 'error_budget_consumed',
    value: 'error_budget_consumed',
    onClick: () => {
      handleChangeSortBy({
        value: 'error_budget_consumed',
        label: _i18n.i18n.translate('xpack.slo.list.sortBy.errorBudgetConsumed', {
          defaultMessage: 'Error budget consumed'
        })
      });
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.sortBy.errorBudgetRemaining', {
      defaultMessage: 'Error budget remaining'
    }),
    checked: sortBy === 'error_budget_remaining',
    value: 'error_budget_remaining',
    onClick: () => {
      handleChangeSortBy({
        value: 'error_budget_remaining',
        label: _i18n.i18n.translate('xpack.slo.list.sortBy.errorBudgetRemaining', {
          defaultMessage: 'Error budget remaining'
        })
      });
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.sortBy.fiveMinuteBurnRate', {
      defaultMessage: '5m burn rate'
    }),
    checked: sortBy === 'burn_rate_5m',
    value: 'burn_rate_5m',
    onClick: () => {
      handleChangeSortBy({
        value: 'burn_rate_5m',
        label: _i18n.i18n.translate('xpack.slo.list.sortBy.fiveMinuteBurnRate', {
          defaultMessage: '5m burn rate'
        })
      });
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.sortBy.oneHourBurnRate', {
      defaultMessage: '1h burn rate'
    }),
    checked: sortBy === 'burn_rate_1h',
    value: 'burn_rate_1h',
    onClick: () => {
      handleChangeSortBy({
        value: 'burn_rate_1h',
        label: _i18n.i18n.translate('xpack.slo.list.sortBy.oneHourBurnRate', {
          defaultMessage: '1h burn rate'
        })
      });
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.sortBy.oneDayBurnRate', {
      defaultMessage: '1d burn rate'
    }),
    checked: sortBy === 'burn_rate_1d',
    value: 'burn_rate_1d',
    onClick: () => {
      handleChangeSortBy({
        value: 'burn_rate_1d',
        label: _i18n.i18n.translate('xpack.slo.list.sortBy.oneDayBurnRate', {
          defaultMessage: '1d burn rate'
        })
      });
    }
  }];
  const groupLabel = ((_sortByOptions$find = sortByOptions.find(option => option.value === sortBy)) === null || _sortByOptions$find === void 0 ? void 0 : _sortByOptions$find.label) || 'Default';
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    key: "group_title_panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, SORT_BY_LABEL))), ...sortByOptions.map(option => /*#__PURE__*/_react.default.createElement(_slo_context_menu.ContextMenuItem, {
    option: option,
    onClosePopover: () => setIsSortByPopoverOpen(false),
    key: option.value
  }))];
  return /*#__PURE__*/_react.default.createElement(_slo_context_menu.SLOContextMenu, {
    items: items,
    id: "SortBy",
    selected: groupLabel,
    isPopoverOpen: isSortByPopoverOpen,
    setIsPopoverOpen: setIsSortByPopoverOpen,
    label: SORT_BY_LABEL,
    loading: loading
  });
}
const SORT_BY_LABEL = _i18n.i18n.translate('xpack.slo.list.sortByTypeLabel', {
  defaultMessage: 'Sort by'
});