"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RESET_SLO = exports.REMOTE_NAME_PARAM = exports.INSTANCE_SEARCH_PARAM = exports.ENABLE_SLO = exports.DISABLE_SLO = exports.DELETE_SLO = void 0;
exports.useGetQueryParams = useGetQueryParams;
var _sloSchema = require("@kbn/slo-schema");
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTANCE_SEARCH_PARAM = exports.INSTANCE_SEARCH_PARAM = 'instanceId';
const REMOTE_NAME_PARAM = exports.REMOTE_NAME_PARAM = 'remoteName';
const DELETE_SLO = exports.DELETE_SLO = 'delete';
const RESET_SLO = exports.RESET_SLO = 'reset';
const ENABLE_SLO = exports.ENABLE_SLO = 'enable';
const DISABLE_SLO = exports.DISABLE_SLO = 'disable';
function useGetQueryParams() {
  const {
    search,
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const searchParams = new URLSearchParams(search);
  const instanceId = searchParams.get(INSTANCE_SEARCH_PARAM);
  const remoteName = searchParams.get(REMOTE_NAME_PARAM);
  const deleteSlo = searchParams.get(DELETE_SLO);
  const resetSlo = searchParams.get(RESET_SLO);
  const enableSlo = searchParams.get(ENABLE_SLO);
  const disableSlo = searchParams.get(DISABLE_SLO);
  const removeDeleteQueryParam = (0, _react.useCallback)(() => {
    const qParams = new URLSearchParams(search);

    // remote delete param from url after initial load
    if (deleteSlo === 'true') {
      qParams.delete(DELETE_SLO);
      history.replace({
        pathname,
        search: qParams.toString()
      });
    }
  }, [deleteSlo, history, pathname, search]);
  const removeResetQueryParam = (0, _react.useCallback)(() => {
    const qParams = new URLSearchParams(search);

    // remote reset param from url after initial load
    if (resetSlo === 'true') {
      qParams.delete(RESET_SLO);
      history.replace({
        pathname,
        search: qParams.toString()
      });
    }
  }, [resetSlo, history, pathname, search]);
  const removeEnableQueryParam = (0, _react.useCallback)(() => {
    const qParams = new URLSearchParams(search);

    // remote enable param from url after initial load
    if (enableSlo === 'true') {
      qParams.delete(ENABLE_SLO);
      history.replace({
        pathname,
        search: qParams.toString()
      });
    }
  }, [enableSlo, history, pathname, search]);
  const removeDisableQueryParam = (0, _react.useCallback)(() => {
    const qParams = new URLSearchParams(search);

    // remote disable param from url after initial load
    if (disableSlo === 'true') {
      qParams.delete(DISABLE_SLO);
      history.replace({
        pathname,
        search: qParams.toString()
      });
    }
  }, [disableSlo, history, pathname, search]);
  return {
    instanceId: !!instanceId && instanceId !== _sloSchema.ALL_VALUE ? instanceId : undefined,
    remoteName: remoteName !== null ? remoteName : undefined,
    isDeletingSlo: deleteSlo === 'true',
    removeDeleteQueryParam,
    isResettingSlo: resetSlo === 'true',
    removeResetQueryParam,
    isEnablingSlo: enableSlo === 'true',
    removeEnableQueryParam,
    isDisablingSlo: disableSlo === 'true',
    removeDisableQueryParam
  };
}