"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloErrorBudget = SloErrorBudget;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_historical_summary = require("../../../hooks/use_fetch_historical_summary");
var _use_fetch_slo_details = require("../../../hooks/use_fetch_slo_details");
var _use_fetch_slo_list = require("../../../hooks/use_fetch_slo_list");
var _error_budget_chart = require("../../../pages/slo_details/components/error_budget_chart");
var _error_budget_header = require("../../../pages/slo_details/components/error_budget_header");
var _slo_groupings = require("../../../pages/slos/components/common/slo_groupings");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _slo_overview_details = require("../common/slo_overview_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloErrorBudget({
  sloId,
  sloInstanceId,
  onRenderComplete,
  reloadSubject
}) {
  var _sloList$results;
  const containerRef = (0, _react.useRef)(null);
  const [selectedSlo, setSelectedSlo] = (0, _react.useState)(null);
  const [lastRefreshTime, setLastRefreshTime] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.subscribe(() => {
      setLastRefreshTime(Date.now());
    });
    return () => {
      reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.unsubscribe();
    };
  }, [reloadSubject]);
  const kqlQuery = `slo.id:"${sloId}" and slo.instanceId:"${sloInstanceId}"`;
  const {
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    kqlQuery
  });
  const {
    isLoading: historicalSummaryLoading,
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloList: (_sloList$results = sloList === null || sloList === void 0 ? void 0 : sloList.results) !== null && _sloList$results !== void 0 ? _sloList$results : [],
    shouldRefetch: false
  });
  const sloHistoricalSummary = historicalSummaries.find(historicalSummary => historicalSummary.sloId === sloId && historicalSummary.instanceId === (sloInstanceId !== null && sloInstanceId !== void 0 ? sloInstanceId : _sloSchema.ALL_VALUE));
  const errorBudgetBurnDownData = (0, _chart_data_formatter.formatHistoricalData)(sloHistoricalSummary === null || sloHistoricalSummary === void 0 ? void 0 : sloHistoricalSummary.data, 'error_budget_remaining');
  const {
    isLoading,
    data: slo,
    refetch,
    isRefetching
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId,
    instanceId: sloInstanceId
  });
  (0, _react.useEffect)(() => {
    refetch();
  }, [lastRefreshTime, refetch]);
  (0, _react.useEffect)(() => {
    if (!onRenderComplete) return;
    if (!isLoading) {
      onRenderComplete();
    }
  }, [isLoading, onRenderComplete]);
  if (isRefetching || isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null)));
  }
  const isSloNotFound = slo === undefined;
  if (isSloNotFound) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.slo.sloEmbeddable.overview.sloNotFoundText', {
      defaultMessage: 'The SLO has been deleted. You can safely delete the widget from the dashboard.'
    })));
  }
  const hasGroupBy = slo.instanceId !== _sloSchema.ALL_VALUE;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-shared-item": "",
    ref: containerRef,
    style: {
      width: '100%',
      padding: 10
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    css: {
      fontSize: '16px'
    },
    "data-test-subj": "o11ySloErrorBudgetLink",
    onClick: () => {
      setSelectedSlo(slo);
    }
  }, /*#__PURE__*/_react.default.createElement("h4", null, slo.name))), hasGroupBy && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_slo_groupings.SLOGroupings, {
    slo: slo
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_error_budget_header.ErrorBudgetHeader, {
    hideTitle: true,
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_error_budget_chart.ErrorBudgetChart, {
    data: errorBudgetBurnDownData,
    isLoading: historicalSummaryLoading,
    slo: slo
  })), /*#__PURE__*/_react.default.createElement(_slo_overview_details.SloOverviewDetails, {
    slo: selectedSlo,
    setSelectedSlo: setSelectedSlo
  }));
}