"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloSelector = SloSelector;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _sloSchema = require("@kbn/slo-schema");
var _use_fetch_slo_list = require("../../../hooks/use_fetch_slo_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_REQUIRED = _i18n.i18n.translate('xpack.slo.sloEmbeddable.config.errors.sloRequired', {
  defaultMessage: 'SLO is required.'
});
function SloSelector({
  initialSlos,
  onSelected,
  hasError,
  singleSelection
}) {
  const mapSlosToOptions = slos => {
    var _slos$map;
    return (_slos$map = slos === null || slos === void 0 ? void 0 : slos.map(slo => ({
      label: slo.instanceId !== _sloSchema.ALL_VALUE ? `${slo.name} (${slo.instanceId})` : slo.name,
      value: `${slo.id}-${slo.instanceId}`
    }))) !== null && _slos$map !== void 0 ? _slos$map : [];
  };
  const [options, setOptions] = (0, _react.useState)([]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(mapSlosToOptions(initialSlos));
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const query = `${searchValue}*`;
  const {
    isLoading,
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    kqlQuery: `slo.name: (${query}) or slo.instanceId.text: (${query})`,
    perPage: 100
  });
  (0, _react.useEffect)(() => {
    const isLoadedWithData = !isLoading && (sloList === null || sloList === void 0 ? void 0 : sloList.results) !== undefined;
    const opts = isLoadedWithData ? mapSlosToOptions(sloList === null || sloList === void 0 ? void 0 : sloList.results) : [];
    setOptions(opts);
  }, [isLoading, sloList]);
  const onChange = opts => {
    var _results;
    setSelectedOptions(opts);
    const selectedSlos = opts.length >= 1 ? (_results = sloList.results) === null || _results === void 0 ? void 0 : _results.filter(slo => opts.find(opt => opt.value === `${slo.id}-${slo.instanceId}`)) : undefined;
    onSelected(singleSelection ? selectedSlos === null || selectedSlos === void 0 ? void 0 : selectedSlos[0] : selectedSlos);
  };
  const onSearchChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(value => {
    setSearchValue(value);
  }, 300), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: hasError,
    error: hasError ? SLO_REQUIRED : undefined,
    label: _i18n.i18n.translate('xpack.slo.embeddable.sloSelectorLabel', {
      defaultMessage: 'SLO'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.slo.sloEmbeddable.config.sloSelector.ariaLabel', {
      defaultMessage: 'SLO'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEmbeddable.config.sloSelector.placeholder', {
      defaultMessage: 'Select a SLO'
    }),
    "data-test-subj": "sloSelector",
    options: options,
    selectedOptions: selectedOptions,
    async: true,
    isLoading: isLoading,
    onChange: onChange,
    fullWidth: true,
    onSearchChange: onSearchChange,
    isInvalid: hasError,
    singleSelection: singleSelection ? {
      asPlainText: true
    } : undefined
  }));
}