"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionGroupFromReason = getActionGroupFromReason;
exports.getActionGroupWindow = getActionGroupWindow;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getActionGroupFromReason(reason) {
  var _reason$split$0$toLow, _reason$split$;
  const prefix = (_reason$split$0$toLow = (_reason$split$ = reason.split(':')[0]) === null || _reason$split$ === void 0 ? void 0 : _reason$split$.toLowerCase()) !== null && _reason$split$0$toLow !== void 0 ? _reason$split$0$toLow : undefined;
  switch (prefix) {
    case 'critical':
      return _constants.ALERT_ACTION_ID;
    case 'high':
      return _constants.HIGH_PRIORITY_ACTION_ID;
    case 'medium':
      return _constants.MEDIUM_PRIORITY_ACTION_ID;
    case 'low':
    default:
      return _constants.LOW_PRIORITY_ACTION_ID;
  }
}
function getActionGroupWindow(alert) {
  var _alert$fields$ALERT_R, _alert$fields$ALERT_R2;
  const actionGroup = getActionGroupFromReason(alert.reason);
  const actionGroupWindow = ((_alert$fields$ALERT_R = (_alert$fields$ALERT_R2 = alert.fields[_ruleDataUtils.ALERT_RULE_PARAMETERS]) === null || _alert$fields$ALERT_R2 === void 0 ? void 0 : _alert$fields$ALERT_R2.windows) !== null && _alert$fields$ALERT_R !== void 0 ? _alert$fields$ALERT_R : []).find(window => window.actionGroup === actionGroup);
  return actionGroupWindow;
}