"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaErrorBoundaryProvider = exports.KibanaErrorBoundaryDepsProvider = void 0;
exports.useErrorBoundary = useErrorBoundary;
var _react = _interopRequireWildcard(require("react"));
var _error_service = require("./error_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const Context = /*#__PURE__*/_react.default.createContext(null);

/**
 * A Context Provider for Jest and Storybooks
 * @internal
 */
const KibanaErrorBoundaryDepsProvider = ({
  children,
  onClickRefresh,
  errorService
}) => /*#__PURE__*/_react.default.createElement(Context.Provider, {
  value: {
    onClickRefresh,
    errorService
  }
}, children);

/**
 * Provider that uses dependencies to give context to the KibanaErrorBoundary component
 * This provider is aware if services were already created from a higher level of the component tree
 * @public
 */
exports.KibanaErrorBoundaryDepsProvider = KibanaErrorBoundaryDepsProvider;
const KibanaErrorBoundaryProvider = ({
  children,
  analytics
}) => {
  const parentContext = (0, _react.useContext)(Context);
  const value = (0, _react.useMemo)(() => {
    // FIXME: analytics dep is optional - know when not to overwrite
    if (parentContext) {
      return parentContext;
    }
    return {
      onClickRefresh: () => window.location.reload(),
      errorService: new _error_service.KibanaErrorService({
        analytics
      })
    };
  }, [parentContext, analytics]);
  return /*#__PURE__*/_react.default.createElement(Context.Provider, {
    value: value
  }, children);
};

/**
 * Utility that provides context
 * @internal
 */
exports.KibanaErrorBoundaryProvider = KibanaErrorBoundaryProvider;
function useErrorBoundary() {
  const context = (0, _react.useContext)(Context);
  if (!context) {
    throw new Error('Kibana Error Boundary Context is missing. Ensure your component or React root is wrapped with Kibana Error Boundary Context.');
  }
  return context;
}