"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SharePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./index.scss");
var _services = require("./services");
var _url_service = require("../common/url_service");
var _url_service2 = require("./url_service");
var _short_url_client_factory = require("./url_service/short_urls/short_url_client_factory");
var _legacy_short_url_locator = require("../common/url_service/locators/legacy_short_url_locator");
var _short_url_redirect_locator = require("../common/url_service/locators/short_url_redirect_locator");
var _registrations = require("./lib/registrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @public */

/** @public */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class SharePlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "shareRegistry", new _services.ShareRegistry());
    (0, _defineProperty2.default)(this, "shareContextMenu", new _services.ShareMenuManager());
    (0, _defineProperty2.default)(this, "redirectManager", void 0);
    (0, _defineProperty2.default)(this, "url", void 0);
    (0, _defineProperty2.default)(this, "anonymousAccessServiceProvider", void 0);
    (0, _defineProperty2.default)(this, "licenseSubscription", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core) {
    const {
      analytics,
      http
    } = core;
    const {
      basePath
    } = http;
    this.url = new _url_service.UrlService({
      baseUrl: basePath.get(),
      version: this.initializerContext.env.packageInfo.version,
      navigate: async ({
        app,
        path,
        state
      }, {
        replace = false
      } = {}) => {
        const [start] = await core.getStartServices();
        await start.application.navigateToApp(app, {
          path,
          state,
          replace
        });
      },
      getUrl: async ({
        app,
        path
      }, {
        absolute
      }) => {
        const start = await core.getStartServices();
        const url = start[0].application.getUrlForApp(app, {
          path,
          absolute
        });
        return url;
      },
      shortUrls: ({
        locators
      }) => new _short_url_client_factory.BrowserShortUrlClientFactory({
        http,
        locators
      })
    });
    this.url.locators.create(new _legacy_short_url_locator.LegacyShortUrlLocatorDefinition());
    this.url.locators.create(new _short_url_redirect_locator.ShortUrlRedirectLocatorDefinition());
    this.redirectManager = new _url_service2.RedirectManager({
      url: this.url
    });
    this.redirectManager.registerLocatorRedirectApp(core);
    this.redirectManager.registerLegacyShortUrlRedirectApp(core);
    _registrations.registrations.setup({
      analytics
    });
    return {
      ...this.shareRegistry.setup(),
      url: this.url,
      navigate: options => this.redirectManager.navigate(options),
      setAnonymousAccessServiceProvider: provider => {
        if (this.anonymousAccessServiceProvider) {
          throw new Error('Anonymous Access service provider is already set.');
        }
        this.anonymousAccessServiceProvider = provider;
      }
    };
  }
  start(core, {
    licensing
  }) {
    var _licensing$license$;
    const isServerless = this.initializerContext.env.packageInfo.buildFlavor === 'serverless';
    let license;
    this.licenseSubscription = licensing === null || licensing === void 0 ? void 0 : (_licensing$license$ = licensing.license$) === null || _licensing$license$ === void 0 ? void 0 : _licensing$license$.subscribe(_license => {
      license = _license;
    });
    const {
      resolveShareItemsForShareContext,
      availableIntegrations
    } = this.shareRegistry.start({
      urlService: this.url,
      anonymousAccessServiceProvider: () => this.anonymousAccessServiceProvider(),
      capabilities: core.application.capabilities,
      getLicense: () => license
    });
    const sharingContextMenuStart = this.shareContextMenu.start({
      core,
      isServerless,
      resolveShareItemsForShareContext
    });
    return {
      ...sharingContextMenuStart,
      url: this.url,
      navigate: options => this.redirectManager.navigate(options),
      availableIntegrations
    };
  }
  stop() {
    var _this$licenseSubscrip;
    (_this$licenseSubscrip = this.licenseSubscription) === null || _this$licenseSubscrip === void 0 ? void 0 : _this$licenseSubscrip.unsubscribe();
  }
}
exports.SharePlugin = SharePlugin;