"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listEntitiesRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../../common/entity_analytics/entity_store/constants");
var _list_entities = require("../../../../../../common/api/entity_analytics/entity_store/entities/list_entities.gen");
var _common = require("../../../../../../common");
var _constants2 = require("../../../../../../common/entity_analytics/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: List Entity Store engines
 *   version: 1
 */

const listEntitiesRoute = (router, logger) => {
  router.versioned.get({
    access: 'public',
    path: _constants.LIST_ENTITIES_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_common.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_list_entities.ListEntitiesRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const {
        page = 1,
        per_page: perPage = 10,
        sort_field: sortField = '@timestamp',
        sort_order: sortOrder = 'desc',
        entity_types: entityTypes,
        filterQuery
      } = request.query;
      const securitySolution = await context.securitySolution;
      const entityStoreClient = securitySolution.getEntityStoreDataClient();
      const {
        records,
        total,
        inspect
      } = await entityStoreClient.searchEntities({
        entityTypes: entityTypes,
        // convert from OpenApi type to internal type
        filterQuery,
        page,
        perPage,
        sortField,
        sortOrder
      });
      return response.ok({
        body: {
          records,
          total,
          page,
          per_page: perPage,
          inspect
        }
      });
    } catch (e) {
      logger.error(e);
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.listEntitiesRoute = listEntitiesRoute;