"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetCriticalityPublicListRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../common/constants");
var _check_and_init_asset_criticality_resources = require("../check_and_init_asset_criticality_resources");
var _asset_criticality = require("../../../../../common/api/entity_analytics/asset_criticality");
var _audit = require("../audit");
var _audit2 = require("../../audit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetCriticalityPublicListRoute = (router, logger) => {
  router.versioned.get({
    access: 'public',
    path: _constants.ASSET_CRITICALITY_PUBLIC_LIST_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_asset_criticality.FindAssetCriticalityRecordsRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      var _securitySolution$get;
      await (0, _check_and_init_asset_criticality_resources.checkAndInitAssetCriticalityResources)(context, logger);
      const securitySolution = await context.securitySolution;
      const assetCriticalityClient = securitySolution.getAssetCriticalityDataClient();
      const {
        page = 1,
        per_page: perPage = 10,
        sort_field: sortField,
        sort_direction: sortDirection = 'asc',
        kuery
      } = request.query;
      const from = (page - 1) * perPage;
      const sort = sortField ? [{
        [sortField]: sortDirection
      }] : undefined;
      const searchRes = await assetCriticalityClient.searchByKuery({
        kuery,
        from,
        size: perPage,
        sort
      });
      const {
        records,
        total
      } = assetCriticalityClient.formatSearchResponse(searchRes);
      (_securitySolution$get = securitySolution.getAuditLogger()) === null || _securitySolution$get === void 0 ? void 0 : _securitySolution$get.log({
        message: 'User searched criticality levels',
        event: {
          action: _audit.AssetCriticalityAuditActions.ASSET_CRITICALITY_SEARCH,
          category: _audit2.AUDIT_CATEGORY.DATABASE,
          type: _audit2.AUDIT_TYPE.ACCESS,
          outcome: _audit2.AUDIT_OUTCOME.SUCCESS
        }
      });
      const body = {
        records,
        total,
        page,
        per_page: perPage
      };
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  });
};
exports.assetCriticalityPublicListRoute = assetCriticalityPublicListRoute;