"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.importRuleActionConnectors = void 0;
var _stream = require("stream");
var _boom = require("@hapi/boom");
var _utils = require("./utils");
var _utils2 = require("../../../../routes/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_ACTION_RESULT = {
  success: true,
  errors: [],
  successCount: 0,
  warnings: []
};
const importRuleActionConnectors = async ({
  actionConnectors,
  actionsImporter,
  overwrite
}) => {
  try {
    if (!actionConnectors.length) {
      return NO_ACTION_RESULT;
    }
    const readStream = _stream.Readable.from(actionConnectors);
    const {
      success,
      successCount,
      warnings,
      errors
    } = await actionsImporter.import({
      readStream,
      overwrite,
      createNewCopies: false
    });
    return {
      success,
      successCount,
      errors: errors ? (0, _utils.mapSOErrorsToBulkErrors)(errors) : [],
      warnings: warnings || []
    };
  } catch (exc) {
    if ((0, _boom.isBoom)(exc) && exc.output.statusCode === 403) {
      return {
        success: false,
        successCount: 0,
        errors: [(0, _utils2.createBulkErrorObject)({
          statusCode: 403,
          message: `You may not have actions privileges required to import actions: ${exc.output.payload.message}`
        })],
        warnings: []
      };
    } else {
      throw exc;
    }
  }
};
exports.importRuleActionConnectors = importRuleActionConnectors;